/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Silvan Nellen
   co-programmer: ...
*/

#include "util/loading/factory.h"
#include "space_trigger.h"
#include "debug.h"

ObjectListDefinition(SpaceTrigger);
CREATE_FACTORY(SpaceTrigger);

CREATE_SCRIPTABLE_CLASS(SpaceTrigger,
            // Coordinates
                        addMethod("setAbsCoor", Executor3<PNode, lua_State*,float,float,float>(&PNode::setAbsCoor))
                            ->addMethod("getAbsCoorX", Executor0ret<PNode, lua_State*, float>(&PNode::getAbsCoorX))
                            ->addMethod("getAbsCoorY", Executor0ret<PNode, lua_State*, float>(&PNode::getAbsCoorY))
                            ->addMethod("getAbsCoorZ", Executor0ret<PNode, lua_State*, float>(&PNode::getAbsCoorZ))
            //Properties
                            ->addMethod("setName", Executor1<BaseObject, lua_State*, const std::string&>(&BaseObject::setName))
                            ->addMethod("setTarget", Executor1<SpaceTrigger, lua_State*, const std::string&>(&SpaceTrigger::setTarget))
                            ->addMethod("setTriggerParent", Executor1<ScriptTrigger, lua_State*, const std::string&>(&ScriptTrigger::setTriggerParent))
                            ->addMethod("setTriggerRemains", Executor1<SpaceTrigger, lua_State*, bool>(&SpaceTrigger::setTriggerRemains))
                            ->addMethod("setInvert", Executor1<SpaceTrigger, lua_State*, bool>(&SpaceTrigger::setInvert))
                            ->addMethod("setRadius", Executor1<SpaceTrigger, lua_State*, float>(&SpaceTrigger::setRadius))
                            ->addMethod("setScript", Executor1<ScriptTrigger, lua_State*, const std::string&>(&ScriptTrigger::setScript))
                            ->addMethod("setFunction", Executor1<ScriptTrigger, lua_State*, const std::string&>(&ScriptTrigger::setFunction))
                            ->addMethod("setDebugDraw", Executor1<ScriptTrigger, lua_State*, bool>(&ScriptTrigger::setDebugDraw))
                            ->addMethod("setAddToScript", Executor1<ScriptTrigger, lua_State*, bool>(&ScriptTrigger::setAddToScript))
                       );


/**
 * Constructs a new SpaceTrigger.
 * @param root the xml element to load the parameters from.
 *
 */
SpaceTrigger::SpaceTrigger(const TiXmlElement* root)
{
  this->registerObject(this, SpaceTrigger::_objectList);

  radius = 10;
  invert = false;
  triggerRemains = true;
 
   if(root != NULL)
  {
    loadParams(root);

    if(addToScript && scriptIsOk)
    {
      script->addObject( "SpaceTrigger", this->getName());
    }

  }

}

/**
 * Deletes the SpaceTrigger.
 *
 */
SpaceTrigger::~SpaceTrigger()
{

}

/**
 * Reads the values from the tml element and sets them.
 * @param root the xml element to load the parameters from.
 *
 */
void SpaceTrigger::loadParams(const TiXmlElement* root)
{

  ScriptTrigger ::loadParams(root);

 
  LoadParam(root, "radius", this, SpaceTrigger, setRadius)
      .describe("the fileName of the script, that should be triggered by this script trigger")
      .defaultValues(0);
  LoadParam(root, "worldentity", this, SpaceTrigger, setTarget)
      .describe("The name of the target as it is in the *.oxw file")
      .defaultValues("");
  LoadParam(root, "invert", this, SpaceTrigger, setInvert)
      .describe("")
      .defaultValues(false);
  LoadParam(root, "triggerRemains", this, SpaceTrigger, setTriggerRemains)
      .describe("")
      .defaultValues(true);
 
}


/**
 * Sets the target(a world entity) of the SpaceTrigger. If the distance between the target and this trigger is smaller than the radius, the script gets triggered.
 * @param target The worldentity that the script supervises.
 */
void SpaceTrigger::setTarget(const std::string& target)
{

  WorldEntity* targetEntity = WorldEntity::objectList().getObject(target);
  if (targetEntity != NULL)
  {
    this->setTarget(targetEntity);
  }
  else
  {
    PRINTF(2)("ERROR SCRTIPTTRIGGER : Target %s for %s::%s does not Exist\n", target.c_str(), this->getClassCName(), this->getCName());
  }
}


void SpaceTrigger::tick(float timestep)
{
  if( scriptFinished ) return;

  if(triggerRemains && scriptCalled )
  {
    executeAction(timestep);
    return;
  }

  if( this->target != NULL)
  {
    if( !invert && this->distance(target) < radius)
    {
    //printf("Distance is %f \n", this->distance(target));
      executeAction(timestep);
      scriptCalled = true;
      return;

    }
    else if( invert && this->distance(target) > radius)
    {
      executeAction(timestep);
      scriptCalled = true;
      return;
    }
  }
}



