/*!
 * @file scrip_trigger.h
 *  triggeres a script
 */

#ifndef _SCRIPT_TRIGGER_H
#define _SCRIPT_TRIGGER_H

#include <string>

#include "world_entity.h"
#include "loading/load_param.h"
#include "script_manager.h"
#include "script.h"


class ScriptTrigger : public WorldEntity
{
  ObjectListDeclaration(ScriptTrigger);
  public:
    ScriptTrigger(const TiXmlElement* root = NULL);
    ~ScriptTrigger();

    ///LOADING
    virtual void loadParams(const TiXmlElement* root);


    /// DO WORK
    virtual void tick(float timestep) = 0;
    virtual void executeAction(float timestep);
    void testScriptingFramework();

    /// SET MEMBER
    void setScript(const std::string& file);
    void setFunction(const std::string& function){ this->functionName = function;}
    void setDebugDraw(const bool draw) { this->doDebugDraw = draw; }
    void setAddToScript(const bool add) { this->addToScript = add; }
    void setTriggerParent(const std::string& name);
    
    
    ///DRAWING
    void draw()const{if(doDebugDraw)this->debugDraw();};

  private:

    bool         doDebugDraw;
    
    //for internal use
    bool         executionStopped;   // true when something goes wrong and the trigger had to be stopped
    int          returnCount;        //TODO: set return count correctly
    
  protected:
    Script*      script;
    std::string  functionName;
    bool         scriptCalled;
    bool         scriptIsOk;
    bool         scriptFinished;
    bool         addToScript;

};


#endif
