/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Silvan Nellen
   co-programmer: ...
*/

#include "util/loading/factory.h"
#include "time_trigger.h"
#include "debug.h"
#include "script_class.h"

ObjectListDefinition(TimeTrigger);
CREATE_FACTORY(TimeTrigger);

CREATE_SCRIPTABLE_CLASS(TimeTrigger,
             // Coordinates
                        addMethod("setAbsCoor", Executor3<PNode, lua_State*,float,float,float>(&PNode::setAbsCoor))
                            ->addMethod("getAbsCoorX", Executor0ret<PNode, lua_State*, float>(&PNode::getAbsCoorX))
                            ->addMethod("getAbsCoorY", Executor0ret<PNode, lua_State*, float>(&PNode::getAbsCoorY))
                            ->addMethod("getAbsCoorZ", Executor0ret<PNode, lua_State*, float>(&PNode::getAbsCoorZ))
             //Properties
                            ->addMethod("setName", Executor1<BaseObject, lua_State*, const std::string&>(&BaseObject::setName))
                            ->addMethod("setScript", Executor1<ScriptTrigger, lua_State*, const std::string&>(&ScriptTrigger::setScript))
                            ->addMethod("setFunction", Executor1<ScriptTrigger, lua_State*, const std::string&>(&ScriptTrigger::setFunction))
                            ->addMethod("setDebugDraw", Executor1<ScriptTrigger, lua_State*, bool>(&ScriptTrigger::setDebugDraw))
                            ->addMethod("start", Executor0<TimeTrigger, lua_State*>(&TimeTrigger::start))
                            ->addMethod("stop", Executor0<TimeTrigger, lua_State*>(&TimeTrigger::stop))
                            ->addMethod("reset", Executor0<TimeTrigger, lua_State*>(&TimeTrigger::reset))
                            ->addMethod("setDelay", Executor1<TimeTrigger, lua_State*, float>(&TimeTrigger::setDelay))
                           
                       );


/**
 * Constructs a new TimeTrigger.
 * @param root the xml element to load the parameters from.
 *
 */
TimeTrigger::TimeTrigger(const TiXmlElement* root)
{
  this->registerObject(this, TimeTrigger::_objectList);
  
  this->delay = 1;
  this->currentTime = delay;
  this->isStopped = true;

  if(root != NULL)
  {
    loadParams(root);

    if(addToScript && scriptIsOk)
    {
      script->addObject( "TimeTrigger", this->getName());
    }

  }

}

/**
 * Deletes the TimeTrigger.
 *
 */
TimeTrigger::~TimeTrigger()
{

}

/**
 * Reads the values from the tml element and sets them.
 * @param root the xml element to load the parameters from.
 *
 */
void TimeTrigger::loadParams(const TiXmlElement* root)
{

  ScriptTrigger ::loadParams(root);

  LoadParam(root, "delay", this, TimeTrigger, setDelay)
      .describe("the time after wich the timer is activated")
      .defaultValues(0);
 
}

void TimeTrigger::tick(float timestep)
{
  if( scriptFinished ) return;
  
  if( !isStopped )
  {
    currentTime -= timestep;
    
    if(currentTime < 0)
    {
      this->executeAction(timestep);
      this->stop();
    }
  
  }

      
}
