/*!
 * @file time_trigger.h
 *  triggers a script after a given time
 */

#ifndef _TIME_TRIGGER_H
#define _TIME_TRIGGER_H

#include <string>

#include "script.h"
#include "script_trigger.h"

class TimeTrigger : public ScriptTrigger
{
  ObjectListDeclaration(TimeTrigger);
  
  public:
    TimeTrigger(const TiXmlElement* root = NULL);
    ~TimeTrigger();
    
    void setDelay(float newDelay){this->currentTime = this->delay = newDelay;}
    void start(){ this->isStopped = false; }
    void stop(){ this->isStopped = true; }
    void reset(){ this->currentTime = delay; }

    /// DO WORK
    virtual void tick(float timestep);
  
  private:
    float delay;
    float currentTime;
    bool  isStopped;

};

#endif
