/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Silvan Nellen
   co-programmer: ...
*/

#include "util/loading/factory.h"
#include "script_class.h"
#include "tick_trigger.h"
#include "debug.h"

ObjectListDefinition(TickTrigger);
CREATE_FACTORY(TickTrigger);

CREATE_SCRIPTABLE_CLASS(TickTrigger,
             // Coordinates
			addMethod("setAbsCoor", Executor3<PNode, lua_State*,float,float,float>(&PNode::setAbsCoor))
			    ->addMethod("getAbsCoorX", Executor0ret<PNode, lua_State*, float>(&PNode::getAbsCoorX))
			    ->addMethod("getAbsCoorY", Executor0ret<PNode, lua_State*, float>(&PNode::getAbsCoorY))
			    ->addMethod("getAbsCoorZ", Executor0ret<PNode, lua_State*, float>(&PNode::getAbsCoorZ))
             //Properties
			    ->addMethod("setName", Executor1<BaseObject, lua_State*, const std::string&>(&BaseObject::setName))
			    ->addMethod("setScript", Executor1<ScriptTrigger, lua_State*, const std::string&>(&ScriptTrigger::setScript))
			    ->addMethod("setFunction", Executor1<ScriptTrigger, lua_State*, const std::string&>(&ScriptTrigger::setFunction))
			    ->addMethod("setDebugDraw", Executor1<ScriptTrigger, lua_State*, bool>(&ScriptTrigger::setDebugDraw))
             );


/**
 * Constructs a new TickTrigger.
 * @param root the xml element to load the parameters from.
 *
 */
TickTrigger::TickTrigger(const TiXmlElement* root)
{
  this->registerObject(this, TickTrigger::_objectList);

  if(root != NULL)
   {
    loadParams(root);

    if(addToScript && scriptIsOk)
    {
      script->addObject( "TickTrigger", this->getName());
    }

   }

}

/**
 * Deletes the TickTrigger.
 *
 */
TickTrigger::~TickTrigger()
{

}


void TickTrigger::tick(float timestep)
{
  if( scriptFinished ) return;

  this->executeAction(timestep);
      
}
