/*!
 * @file animation3d.h
*/


#include "animation.h"

#include "vector.h"
#include "quaternion.h"
class PNode;

#define DELTA_X_3D 0.05  //!< the percentag of the distance that doesn't have to be done by neg_exp (asymptotical) ~ maschinendelta

//! KeyFrame3D Struct
/**
   This represents one point with direction of the animation
*/
typedef struct KeyFrame3D
{
  float             duration;              //!< The duration of this KeyFrame
  Vector            position;              //!< The position of this KeyFrame
  Vector            lastPosition;          //!< The last known position
  Quaternion        direction;             //!< The direction of this KeyFrame
  ANIM_FUNCTION     animFuncMov;           //!< with whitch function to iterate movement to the next KeyFrame3D
  ANIM_FUNCTION     animFuncRot;           //!< with whitch function to iterate rotation to the next KeyFrame3D
};

//! Animation Class for 3D-transformations (movement and rotation)
/**
   This represents an animation for a object
*/
class Animation3D : public Animation
{
public:
  Animation3D(PNode* object);
  virtual ~Animation3D();

  virtual void rewind();

  void addKeyFrame(Vector position, Quaternion direction,
                   float time, ANIM_FUNCTION animFuncMov = ANIM_DEFAULT_FUNCTION,
                   ANIM_FUNCTION animFuncRot = ANIM_NULL);
  //  void addKeyFrame(KeyFrame3D* frame);

  virtual void tick(float dt);

private:
  // animation functions
  void setAnimFuncMov(ANIM_FUNCTION animFunc);
  void setAnimFuncRot(ANIM_FUNCTION animFunc);
  void mConstant(float timePassed) const;
  void mLinear(float timePassed) const;
  void mSine(float timePassed) const;
  void mCosine(float timePassed) const;
  void mExp(float timePassed) const;
  void mNegExp(float timePassed) const;
  void mQuadratic(float timePassed) const;
  void mRandom(float timePassed) const;
  void rConstant(float timePassed) const;
  void rLinear(float timePassed) const;
  void rSine(float timePassed) const;
  void rCosine(float timePassed) const;
  void rExp(float timePassed) const;
  void rNegExp(float timePassed) const;
  void rQuadratic(float timePassed) const;
  void rRandom(float timePassed) const;
  //  ANIM_FUNCTION animFunc;
  void (Animation3D::*animFuncMov)(float) const;      //!< A Function for the AnimationType
  void (Animation3D::*animFuncRot)(float) const;      //!< A Function for the AnimationType


private:
  typedef std::list<KeyFrame3D>  KeyFrameList;        //!< A Type definition for th KeyFrame List
  typedef KeyFrameList::iterator KeyFrameIterator;        //!< A Type definition for th KeyFrame List

  KeyFrameIterator     currentKeyFrame;               //!< The current KeyFrame
  KeyFrameIterator     nextKeyFrame;                  //!< The KeyFrame we iterate to
  KeyFrameList         keyFrameList;                  //!< The KeyFrameList


  // more class-local description
  PNode*               object;                        //!< The Object from which to Animate something
  Vector               lastPosition;                  //!< last Object
  Vector               tmpVect;                       //!< temporary vector
  float                deltaT;                        //!< time passed since last
  float                expFactorMov;                  //!< exponential Factor for movement
  float                expFactorRot;                  //!< exponential Factor for rotation
};
