#ifndef __THREAD_H__
#define __THREAD_H__

#include "threadincl.h"

namespace OrxThread
{
  //! A class for Wrapping Threads
  class Thread
  {
  public:
    Thread(int (*fn)(void *), void *data) { this->thread = SDL_CreateThread(fn, data); };
    virtual ~Thread() { SDL_KillThread(this->thread); }
    void exit ( int returnCode = 0 );
    bool isFinished () const;
    bool isRunning () const;
    void wait() { SDL_WaitThread(this->thread, NULL); };

    void start();
    void terminate();


  private:
    SDL_Thread* thread;

  };
}

#endif /* __THREAD_H__ */
