#ifndef __MUTEX_LOCKER_H__
#define __MUTEX_LOCKER_H__

#include "mutex.h"

namespace OrxThread
{

  //! A Class that locks a Mutex within its scope
  class MutexLocker
  {
  public:
    //! Locks the Mutex mutex in this Scope.
    MutexLocker(Mutex* mutex) { SDL_mutexP(mutex->getMutex()); this->mutex = mutex; };
    ~MutexLocker() { SDL_mutexV(mutex->getMutex()); };
  private:
    Mutex* mutex;         //!< The Mutex to lock.
  };
}

#endif /* __MUTEX_LOCKER_H__ */
