#ifndef __MUTEX_H__
#define __MUTEX_H__


#include "threadincl.h"
namespace OrxThread
{

  class Mutex
  {
  public:
    Mutex() {  this->mutex = SDL_CreateMutex(); };
    ~Mutex() { SDL_DestroyMutex(this->mutex); }

    void lock() { SDL_mutexP(mutex); };
    void unlock() { SDL_mutexV(mutex); };

    SDL_mutex* getMutex() const { return this->mutex; };
  private:
    SDL_mutex* mutex;
  };
}
#endif /* __MUTEX_H__ */
