/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#include "net_link.h"
#include "debug.h"

#include "threads/mutex_locker.h"

#ifdef __OSX__
#include <ApplicationServices/ApplicationServices.h>
#elif defined __WIN32__
//#include <shellapi.h>
#endif


NetLink::NetLink(const std::string& linkName)
{
  this->_link = linkName;
}


void NetLink::openInBrowser() const
{
  SDL_CreateThread(NetLink::openupInBrowser, (void*)&this->_link);
}

OrxThread::Mutex NetLink::_mutex;
std::string NetLink::_defaultBrowser = "firefox";
std::list<std::string> NetLink::_browserList = NetLink::buildBrowserList();




int NetLink::openupInBrowser(void* url)
{
  OrxThread::MutexLocker lock(&NetLink::_mutex);

  std::string URL = *(std::string*)url;
#ifdef __linux__
  system ((std::string(NetLink::defaultBrowser()) + " " + URL).c_str());

#elif defined __OSX__
  CFURLRef url_handle = CFURLCreateWithBytes (NULL, (UInt8 *)URL.c_str(), URL.size(),
                                              kCFStringEncodingASCII, NULL);
  LSOpenCFURLRef (url_handle, NULL);
  CFRelease (url_handle);

#elif defined __WIN32__
  /*  ShellExecute(GetActiveWindow(),
               "open", URL.c_str(), NULL, NULL, SW_SHOWNORMAL);
}*/
#endif
  PRINTF(3)("loaded external webpage %s\n", URL.c_str());

  return 0;
}

void NetLink::setDefaultBrowser(const std::string& browserName)
{
  OrxThread::MutexLocker lock(&NetLink::_mutex);
  NetLink::_defaultBrowser = browserName;
}

std::list<std::string> NetLink::buildBrowserList()
{
  std::list<std::string> browserList;
  browserList.push_back("firefox");
  browserList.push_back("mozilla");
  browserList.push_back("konqueror");

  return  browserList;
}
