/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


   ### File Specific:
   main-programmer: Benjamin Grauer

*/


#include "gui_control.h"

#include <QtGui/QLayout>
#include <QtCore/QEvent>
#include <QtGui/QKeyEvent>
#include <QtGui/QMouseEvent>

#include "sdlincl.h"
#include "lib/event/key_names.h"

#include "orxonox_globals.h"
#include "debug.h"
#include "qt_gui_elements.h"

#include "lib/event/key_mapper.h"
#include "lib/event/key_names.h"

namespace OrxGui
{
  /**
   *  Creates the Control-Option-Frame
  */
  GuiControl::GuiControl(OrxGui::Gui* gui)
      : Element(CONFIG_SECTION_CONTROL, gui), QGroupBox()
  {
    QGridLayout* layout = new QGridLayout(this);

    {
      //QLabel* keyLabel = new QLabel;

      const KeyMapper::KeyMapping* map = KeyMapper::getKeyMapping();
      unsigned int i = 0;
      while(!map->pName.empty())
      {
        QLabel* label = new QLabel(QString().fromStdString(map->pName));
        layout->addWidget(label, i, 0);

        GuiControlInput* input = new GuiControlInput(map->pName, this, EVToKeyName(map->defaultValue));
        layout->addWidget(input, i, 1);

        ++map;
        ++i;
      }
    }


  }

  /**
   *  Destructs the Control-stuff
  */
  GuiControl::~GuiControl()
  {
    // nothing to do here.
  }

  GuiControlInput::GuiControlInput(const std::string& name, SaveableGroup* group, const std::string& defaultValue)
      : QPushButton(QString().fromStdString(name)), Saveable(name, group, defaultValue)
  {
    this->bListening = false;

    connect(this, SIGNAL(released()), this, SLOT(listen()));

  }

  void GuiControlInput::load()
  {
    Saveable::load();
    this->setText(QString().fromStdString(this->value().getString()));
  }

  void GuiControlInput::save()
  {
    this->value() = this->text().toStdString();
    Saveable::save();
  }


  bool GuiControlInput::event ( QEvent * e )
  {
    if (this->bListening && (e->type() == QEvent::KeyPress || e->type() == QEvent::MouseButtonPress))
    {
      this->bListening = false;
      this->releaseKeyboard();
      this->releaseMouse();
      /// KEY IS PRESSED:
      if (e->type() == QEvent::KeyPress)
      {
        QKeyEvent* event = dynamic_cast<QKeyEvent*>(e);

        int ev = QtKToSDLK(event->key());
        if (ev != -1)
        {
          this->setText(QString().fromStdString(SDLKToKeyname(ev)));
        }
        return true;
      }
      /// MOUSE BUTTON PRESSED:
      if (e->type() == QEvent::MouseButtonPress)
      {
        QMouseEvent* event = dynamic_cast<QMouseEvent*>(e);
        if (event->button() != Qt::NoButton)
        {
          this->setText(QString().fromStdString(QtKToString(event->button())));
        }

      }

    }

    return QPushButton::event(e);
  }

  void GuiControlInput::listen()
  {
    this->bListening = true;
    this->grabKeyboard();
    this->grabMouse();
  }

  int GuiControlInput::QtKToSDLK(int key)
  {

    switch(key)
    {
      case Qt::Key_Backspace: return SDLK_BACKSPACE;
      case Qt::Key_Tab: return SDLK_TAB;
      case Qt::Key_Clear: return SDLK_CLEAR;
      case Qt::Key_Return: return SDLK_RETURN;
      case Qt::Key_Escape: return SDLK_ESCAPE;
      case Qt::Key_Space: return SDLK_SPACE;
      case Qt::Key_exclamdown: return SDLK_EXCLAIM;
      case Qt::Key_QuoteDbl: return SDLK_QUOTEDBL;
        //case Qt::Key_Hash: return SDLK_HASH;
      case Qt::Key_Pause: return SDLK_PAUSE;
      case Qt::Key_Dollar: return SDLK_DOLLAR;
      case Qt::Key_Ampersand: return SDLK_AMPERSAND;
      case Qt::Key_QuoteLeft: return SDLK_QUOTE; /// TODO check if correct
      case Qt::Key_ParenLeft: return SDLK_LEFTPAREN;
      case Qt::Key_ParenRight: return SDLK_RIGHTPAREN;
      case Qt::Key_Asterisk: return SDLK_ASTERISK;
      case Qt::Key_Plus: return SDLK_PLUS;
      case Qt::Key_Comma: return SDLK_COMMA;
      case Qt::Key_Minus: return SDLK_MINUS;
      case Qt::Key_Period: return SDLK_PERIOD;
      case Qt::Key_Slash: return SDLK_SLASH;
      case Qt::Key_0: return SDLK_0;
      case Qt::Key_1: return SDLK_1;
      case Qt::Key_2: return SDLK_2;
      case Qt::Key_3: return SDLK_3;
      case Qt::Key_4: return SDLK_4;
      case Qt::Key_5: return SDLK_5;
      case Qt::Key_6: return SDLK_6;
      case Qt::Key_7: return SDLK_7;
      case Qt::Key_8: return SDLK_8;
      case Qt::Key_9: return SDLK_9;
      case Qt::Key_Colon: return SDLK_COLON;
      case Qt::Key_Semicolon: return SDLK_SEMICOLON;
      case Qt::Key_Less: return SDLK_LESS;
      case Qt::Key_Equal: return SDLK_EQUALS;
      case Qt::Key_Greater: return SDLK_GREATER;
      case Qt::Key_Question: return SDLK_QUESTION;
      case Qt::Key_At: return SDLK_AT;
      case Qt::Key_BracketLeft: return SDLK_LEFTBRACKET;
      case Qt::Key_Backslash: return SDLK_BACKSLASH;
      case Qt::Key_BracketRight: return SDLK_RIGHTBRACKET;
        ///case Qt::Key_Caret: return SDLK_CARET;
      case Qt::Key_Underscore: return SDLK_UNDERSCORE;
        //case Qt::Key_Backquote: return SDLK_BACKQUOTE;
      case Qt::Key_A: return SDLK_a;
      case Qt::Key_B: return SDLK_b;
      case Qt::Key_C: return SDLK_c;
      case Qt::Key_D: return SDLK_d;
      case Qt::Key_E: return SDLK_e;
      case Qt::Key_F: return SDLK_f;
      case Qt::Key_G: return SDLK_g;
      case Qt::Key_H: return SDLK_h;
      case Qt::Key_I: return SDLK_i;
      case Qt::Key_J: return SDLK_j;
      case Qt::Key_K: return SDLK_k;
      case Qt::Key_L: return SDLK_l;
      case Qt::Key_M: return SDLK_m;
      case Qt::Key_N: return SDLK_n;
      case Qt::Key_O: return SDLK_o;
      case Qt::Key_P: return SDLK_p;
      case Qt::Key_Q: return SDLK_q;
      case Qt::Key_R: return SDLK_r;
      case Qt::Key_S: return SDLK_s;
      case Qt::Key_T: return SDLK_t;
      case Qt::Key_U: return SDLK_u;
      case Qt::Key_V: return SDLK_v;
      case Qt::Key_W: return SDLK_w;
      case Qt::Key_X: return SDLK_x;
      case Qt::Key_Y: return SDLK_y;
      case Qt::Key_Z: return SDLK_z;
      case Qt::Key_Delete: return SDLK_DELETE;
        /*      case Qt::Key_KP0: return SDLK_KP0;
        case Qt::Key_KP1: return SDLK_KP1;
        case Qt::Key_KP2: return SDLK_KP2;
        case Qt::Key_KP3: return SDLK_KP3;
        case Qt::Key_KP4: return SDLK_KP4;
        case Qt::Key_KP5: return SDLK_KP5;
        case Qt::Key_KP6: return SDLK_KP6;
        case Qt::Key_KP7: return SDLK_KP7;
        case Qt::Key_KP8: return SDLK_KP8;
        case Qt::Key_KP9: return SDLK_KP9; */
        /*      case Qt::Key_KP_Period: return SDLK_KP_PERIOD;
              case Qt::Key_KP_Divide: return SDLK_KP_DIVIDE;
              case Qt::Key_KP_Multiply: return SDLK_KP_MULTIPLY;
              case Qt::Key_KP_Minus: return SDLK_KP_MINUS;
              case Qt::Key_KP_PLUS: return SDLK_KP_PLUS;
              case Qt::Key_KP_ENTER: return SDLK_KP_ENTER;
              case Qt::Key_KP_EQUALS: return SDLK_KP_EQUALS;*/
      case Qt::Key_Up: return SDLK_UP;
      case Qt::Key_Down: return SDLK_DOWN;
      case Qt::Key_Right: return SDLK_RIGHT;
      case Qt::Key_Left: return SDLK_LEFT;
      case Qt::Key_Insert: return SDLK_INSERT;
      case Qt::Key_Home: return SDLK_HOME;
      case Qt::Key_End: return SDLK_END;
      case Qt::Key_PageUp: return SDLK_PAGEUP;
      case Qt::Key_PageDown: return SDLK_PAGEDOWN;
      case Qt::Key_F1: return SDLK_F1;
      case Qt::Key_F2: return SDLK_F2;
      case Qt::Key_F3: return SDLK_F3;
      case Qt::Key_F4: return SDLK_F4;
      case Qt::Key_F5: return SDLK_F5;
      case Qt::Key_F6: return SDLK_F6;
      case Qt::Key_F7: return SDLK_F7;
      case Qt::Key_F8: return SDLK_F8;
      case Qt::Key_F9: return SDLK_F9;
      case Qt::Key_F10: return SDLK_F10;
      case Qt::Key_F11: return SDLK_F11;
      case Qt::Key_F12: return SDLK_F12;
      case Qt::Key_F13: return SDLK_F13;
      case Qt::Key_F14: return SDLK_F14;
      case Qt::Key_F15: return SDLK_F15;
      case Qt::Key_NumLock: return SDLK_NUMLOCK;
      case Qt::Key_CapsLock: return SDLK_CAPSLOCK;
      case Qt::Key_ScrollLock: return SDLK_SCROLLOCK;
        ///case Qt::Key_RSHIFT: return SDLK_RSHIFT;
      case Qt::Key_Shift: return SDLK_LSHIFT;
        ///case Qt::Key_RCTRL: return SDLK_RCTRL;
      case Qt::Key_Control: return SDLK_LCTRL;
        ///case Qt::Key_RALT: return SDLK_RALT;
      case Qt::Key_Alt: return SDLK_LALT;
        //case Qt::Key_RMETA: return SDLK_RMETA;
      case Qt::Key_Meta: return SDLK_LMETA;
      case Qt::Key_Super_L: return SDLK_LSUPER;
      case Qt::Key_Super_R: return SDLK_RSUPER;
      case Qt::Key_Mode_switch: return SDLK_MODE;
      case Qt::Key_Help: return SDLK_HELP;
      case Qt::Key_Print: return SDLK_PRINT;
      case Qt::Key_SysReq: return SDLK_SYSREQ;
        ///case Qt::Key_Break: return SDLK_BREAK;
        ///case Qt::Key_Menu: return SDLK_MENU;
        ///case Qt::Key_Power: return SDLK_POWER;
        ///case Qt::Key_Euro: return SDLK_EURO;
      default:
        return -1;
    }

    return 0;

  }

  std::string GuiControlInput::QtKToString(int button)
  {
    if( button == Qt::LeftButton) return "BUTTON_LEFT";
    if( button == Qt::MidButton) return "BUTTON_MIDDLE";
    if( button == Qt::RightButton) return "BUTTON_RIGHT";
    //if( button == Qt::) return "BUTTON_WHEELUP";
    //if( button == EV_MOUSE_BUTTON_WHEELDOWN) return "BUTTON_WHEELDOWN";
    return "UNKNOWN";
  }

}
