/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: bottac@ee.ethz.ch

   Inspired by:
   Rendering Q3 Maps by Morgan McGuire                  http://graphics.cs.brown.edu/games/quake/quake3.html
   Unofficial Quake 3 Map Specs by Kekoa Proudfoot      http://graphics.stanford.edu/~kekoa/q3/

   Collision detection adapted from:
   Quake 3 Collision Detection by Nathan Ostgard        http://www.devmaster.net/articles/quake3collision/
*/

#ifndef _BSP_MANAGER_H
#define _BSP_MANAGER_H


#include <vector>
#include <deque>


#define BSP_X_OFFSET 20.0f
#define BSP_Y_OFFSET 40.0f
#define BSP_Z_OFFSET 20.0f


// FORWARD DECLARATIONS
class  BspFile;
class BspTreeLeaf;
class BspTreeNode;
class Vector;
class set;
struct face;
struct brush;
struct plane;

class WorldEntity;


// Obsolete
struct BspCollisionEvent
{
  Vector normal; //!< normal Vector, length 1
  Vector place;  //!< Absoloute coordinates of collision
};

class BspManager
{
public:
  // Constructors
  BspManager(WorldEntity* parent);

  BspManager(const char* fileName, float scale = 0.4f);

  // Deconstructor
  ~BspManager();



  // Functions
  int load(const char* fileName, float scale);
  const void draw();
  const void tick(float time);
  void draw_debug_face(int Face);
  void draw_face(int Face);
  void draw_patch(face* Face);


  void checkCollision(WorldEntity* worldEntity); /*!< WorldEntities use this function to check wheter they collided with the BspEntity.
                                                      If a collision has been detected, the collides-function of worldEntity will be called.*/

  int sortTransparency;              //!< sort transparent textures
  int sortTransparencyMore;          //!< sort transparent textures better

private:
  // collision functions
  BspTreeNode* getLeaf(BspTreeNode*  node,   Vector* cam) ;  //!< Traverses the tree
  void  checkCollision(BspTreeNode* node, Vector* cam); //!< Obsolete. Use this function for debugging only!
  void  checkCollisionRay(BspTreeNode * node,float startFraction, float endFraction, Vector* start, Vector* end);
  void  checkCollisionRayN(BspTreeNode * node,float startFraction, float endFraction, Vector* start, Vector* end);

  bool checkCollisionX(WorldEntity* entity);
  bool checkCollisionY(WorldEntity* entity);
  bool checkCollisionZ(WorldEntity* entity);
  bool checkCollisionWay(WorldEntity* entity);

  void  checkCollisionBox(void);
  void  checkBrushRay(brush* curBrush);
  void  checkBrushRayN(brush* curBrush);
  void  checkBrushRayN(brush* curBrush, Vector& inputStart, Vector& inputEnd);
  float checkPatchAltitude(BspTreeNode* node); //! To be implemented...

  void  TraceBox( Vector& inputStart, Vector& inputEnd,Vector& inputMins, Vector& inputMaxs );


  // visibility functions
  void drawDebugCube(Vector* cam);
  bool isAlreadyVisible(int Face);
  void addFace(int Face);

  // Data
  BspFile*  bspFile;
  BspTreeNode* root;
  Vector cam;
  Vector ship;
  Vector  viewDir;
  plane* collPlane;
  int lastTex;

  //obsolete: global variables for collision detection
  bool  outputStartsOut;
  bool  outputAllSolid;
  float outputFraction;
  Vector inputStart;
  Vector inputEnd;

  Vector traceMins; //!< Mins of current bbox
  Vector traceMaxs; //!< Maxs of current bbox
  Vector traceExtents; /*!< Stores the maximum of the absolute value of each axis in the box.
                            For example, if traceMins was (-100,-3,-15) and traceMaxs was (55,22,7), traceExtents */

  WorldEntity* parent;          //!< the parent entity of the bspManager: interface to this

  bool * alreadyVisible;
  // Deques to store the visible faces
  ::std::vector<int> trasparent; //!< the ones with transparancy go here
  ::std::vector<int> opal; //!< the others here.

  Vector out;  //!< Stores collision coordinates
  Vector out1; //!< For debugging only
  Vector out2; //!< For debugging only

  int tgl;
};

#endif /* _BSP_MANAGER_H */
