/*!
 * @file scrip_trigger.h
 *  triggeres a script
 */

#ifndef _SCRIPT_TRIGGER_H
#define _SCRIPT_TRIGGER_H

#include <string>

#include "world_entity.h"
#include "loading/load_param.h"
#include "vector.h"
#include "script_manager.h"
#include "script.h"
#include "script_class.h"

class ScriptTrigger : public WorldEntity
{
  ObjectListDeclaration(ScriptTrigger);
  public:
    ScriptTrigger(const TiXmlElement* root = NULL);
    ~ScriptTrigger();

    ///LOADING
    virtual void loadParams(const TiXmlElement* root);


    /// DO WORK
    virtual void tick(float timestep);
    virtual void executeAction(float timestep);
    void testScriptingFramework();

    /// SET MEMBER
 
    void setActiveOnCreation(const bool avtive) { this->activeOnCreation = avtive; }
    void setDelay(float delay) { this->delay = delay; };
    void setScript(const std::string& file);
    void setFunction(const std::string& function){ this->functionName = function;}
    void setDebugDraw(const bool draw) { this->doDebugDraw = draw; }
    void setAddToScript(const bool add) { this->addToScript = add; }
    void setTriggerParent(const std::string& name);
    
    inline void setScriptIsOk(bool ok){ scriptIsOk = ok ; }
    inline void setScriptCalled(bool called){ scriptCalled = called; }
    inline void setScriptFinished(bool finished){ scriptFinished = finished; }
    
    ///POLLING

    inline bool getScriptIsOk(){ return scriptIsOk; }
    inline bool getScriptCalled(){ return scriptCalled; }
    inline bool getScriptFinished(){ return scriptFinished; }
    
    
    ///DRAWING
    void draw()const{if(doDebugDraw)this->debugDraw();};

  private:

    bool         activeOnCreation;
    float        delay;
    Script*      script;
    std::string  functionName;
    bool         doDebugDraw;
    bool         addToScript;
    
    //for internal use
    bool         scriptCalled;
    bool         scriptIsOk;
    bool         executionStopped;   // true when something goes wrong and the trigger has to be stopped
    bool         scriptFinished;
    int          returnCount;        //TODO: set return count correctly

};


#endif
