/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004-2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Marc Schaerrer
   co-programmer:
*/
//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "acid_launcher.h"

#include "weapon_manager.h"
#include "world_entities/projectiles/acid_splash.h"

#include "model.h"

#include "state.h"
#include "animation3d.h"

#include <list>
#include <iterator>
#include "util/state.h"

#include "util/loading/factory.h"

#include "elements/glgui_energywidgetvertical.h"



using namespace std;

ObjectListDefinition ( AcidLauncher );
CREATE_FACTORY ( AcidLauncher );

/**
 *  standard constructor
 *
 * creates a new AcidLauncher
 */
AcidLauncher::AcidLauncher()
    : Weapon()
{
  this->init();
}

/**
 * creates a new AcidLauncher from a TiXmlElement
 */
AcidLauncher::AcidLauncher ( const TiXmlElement* root )
{
  this->init();
  if ( root != NULL )
    this->loadParams ( root );
}

/**
 *  standard deconstructor
*/
AcidLauncher::~AcidLauncher ()
{
  // model will be deleted from WorldEntity-destructor
}

void AcidLauncher::init()
{
  this->registerObject ( this, AcidLauncher::_objectList );
  /*
    Animation3D* animation1 = this->getAnimation(WS_ACTIVATING, this);
    Animation3D* animation2 = this->getAnimation(WS_DEACTIVATING, this);

    animation1->addKeyFrame(Vector(0, -.5, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
    animation1->addKeyFrame(Vector(0, 0, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
    animation2->addKeyFrame(Vector(0, 0, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
    animation2->addKeyFrame(Vector(0, -.5, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);

    animation1->setInfinity(ANIM_INF_CONSTANT);
    animation2->setInfinity(ANIM_INF_CONSTANT);
  */
  this->setStateDuration ( WS_SHOOTING, 1.0f );

  this->setStateDuration ( WS_RELOADING, 1.0f );
  this->setStateDuration ( WS_ACTIVATING, .4 );
  this->setStateDuration ( WS_DEACTIVATING, .4 );

  this->setEnergyMax ( 100 );
  this->increaseEnergy ( 100 );
  //this->minCharge = 2;

  this->setCapability ( WTYPE_ALLDIRS | WTYPE_TURRET | WTYPE_DIRECTIONAL | WTYPE_LIGHT );
  this->setProjectileTypeC ( "AcidSplash" );
//   this->loadModel("models/guns/turret1.obj", 1.0);

  this->setEmissionPoint ( 2.0, 0, 0 );
  this->getProjectileFactory()->prepare ( 10 );

  this->setActionSound ( WA_SHOOT, "sounds/explosions/explosion_1.wav" );
  this->setActionSound ( WA_ACTIVATE, "sounds/voices/rockets.wav" );
//   this->setActionSound(WA_RELOAD, "sounds/voices/reload.wav");

}

void AcidLauncher::loadParams ( const TiXmlElement* root )
{
  Weapon::loadParams ( root );
}

void AcidLauncher::activate()
{}

void AcidLauncher::deactivate()
{}

void AcidLauncher::tick ( float dt )
{
  if ( !Weapon::tickW ( dt ) )
    return;
  if ( this->energyWidget != NULL && !this->isEnergyWidgetInitialized ) {
    this->energyWidget->setDisplayedImage ( "textures/gui/gui_acid.png" );
    this->isEnergyWidgetInitialized = true;
  }


  /*
  Quaternion quat;
  Vector direction;
  if (this->getDefaultTarget() == NULL)
    direction = this->getAbsCoor();
  else
    direction = this->getDefaultTarget()->getAbsCoor() - this->getAbsCoor();

  direction.normalize();

  if (likely (this->getParent() != NULL))
    quat = Quaternion(direction, this->getParent()->getAbsDir().apply(Vector(0,1,0))) * Quaternion ( -M_PI_2, Vector(0,1,0)) ;
  else
    quat = Quaternion(direction, Vector(0,1,0)) * Quaternion ( -M_PI_2, Vector(0,1,0)) ;

  this->setAbsDirSoft(quat, 5);
  */
}

void AcidLauncher::fire()
{
  bool fired  = false;

  Projectile* pj = NULL;
  for ( int i=0; i < 1; i++ ) {
    pj  = this->getProjectile();
    if ( pj == NULL )
      return;

    fired = true;
    pj->setVelocity ( this->getVelocity() + ( this->getAbsDir().apply ( Vector ( 1,0,0 ) ) *165.0 + VECTOR_RAND ( 10 ) ) );

    pj->setParent ( PNode::getNullParent() );
    pj->setAbsCoor ( this->getEmissionPoint() + VECTOR_RAND ( .1 ) );
    pj->setAbsDir ( this->getAbsDir() +Quaternion ( 0,VECTOR_RAND ( 5 ) ) );
    pj->activate();
  }
}
