/*!
 * @file scrip_trigger.h
 *  triggeres a script
 */

#ifndef _SCRIPT_TRIGGER_H
#define _SCRIPT_TRIGGER_H

#include <string>

#include "world_entity.h"
#include "loading/load_param.h"
#include "vector.h"
#include "script_manager.h"
#include "script.h"
#include "script_class.h"

class ScriptTrigger : public WorldEntity
{
  ObjectListDeclaration(ScriptTrigger);
  public:
    ScriptTrigger(const TiXmlElement* root = NULL);
    ~ScriptTrigger();

    ///LOADING
    virtual void loadParams(const TiXmlElement* root);


    /// DO WORK
    virtual void tick(float timestep);
    virtual void executeAction(float timestep);

    /// SET MEMBER
    void setTarget(const std::string& targetName);
    void setTarget(WorldEntity* target) { if(target!=NULL) this->target=target; }
    void setTriggerParent(const std::string& name);
    void setTriggerRemains(const bool lasts) { this->triggerRemains = lasts; }
    void setActiveOnCreation(const bool avtive) { this->activeOnCreation = avtive; }
    void setInvert(const bool inv) { this->invert = invert; }
    void setDelay(float delay) { this->delay = delay; };
    void setRadius(const float radius) { if(radius>0) this->radius = radius; }
    void setScript(const std::string& file);
    void setFunction(const std::string& function){ this->functionName = function;}
    void setDebugDraw(const bool draw) { this->doDebugDraw = draw; }
    void setAddToScript(const bool add) { this->addToScript = add; }

    ///DRAWING
    void draw()const{if(doDebugDraw)this->debugDraw();};

  private:

    WorldEntity* target;
    bool         triggerRemains;
    bool         activeOnCreation;
    bool         invert;
    float        radius;
    float        delay;
    Script*      script;
    std::string  functionName;
    bool         doDebugDraw;
    bool         addToScript;
    //for internal use
    bool         scriptCalled;
    bool         scriptIsOk;
    bool         scriptFinished;
    int          returnCount;        //TODO: set return count correctly

};


#endif
