/*!
 * @file recorder.h
 *
 */

#ifndef _RECORDER_H
#define _RECORDER_H

#include "sdlincl.h"

#ifdef HAVE_AVFORMAT_H
  #include <avformat.h>
#else
  #include <ffmpeg/avformat.h>
#endif

#include "glincl.h"
#include "world_entity.h"

class Recorder : public WorldEntity
{
  ObjectListDeclaration(Recorder);
  public:
    Recorder (const TiXmlElement* root = NULL);
    virtual ~Recorder ();

    virtual void draw () const;
    virtual void tick (float dt);

    virtual void loadParams(const TiXmlElement* root);

  private:
    void initVideo(const std::string& filename);
    void addVideoStream();
    void openVideo();
    void closeVideo();
    void allocPicture();
    void writeVideoFrame();
    void fillYuvImage();

    void setStreamDuration(float duration);
    void setFPS(float fps);


  private:
    AVFrame*            picture;
    uint8_t*            buffer;
    int                 frame_count;
    int                 buffer_size;

    AVOutputFormat*     output_format;
    AVFormatContext*    format_context;
    AVCodecContext*     codec_context;
    AVCodec*            codec;
    AVStream*           video_stream;
    AVPacket            packet;
    double              video_pts;

    uint8_t*            picture_buf;
    int                 size;

    int                 height;
    int                 width;
    float               time;

    float               stream_duration;
    float               stream_frame_rate;
    int                 stream_nb_frames;

    AVFrame*            RGB_frame;
};

#endif /* _RECORDER_H */
