#ifndef _MOUNT_POINT_H
#define _MOUNT_POINT_H

#include "world_entity.h"

class TiXmlElement;


class MountPoint : public WorldEntity
{
    ObjectListDeclaration(MountPoint);

  public:
    MountPoint (const Vector& up, const Vector& forward, const Vector& center, const std::string& name);
    virtual ~MountPoint ();

    void init();
    void initMountPoint(const TiXmlElement* root);
    void loadParam(const TiXmlElement* root);
    void loadDetails(const TiXmlElement* root);

    void setDescription(const std::string& description);
    void setOrxClass(const std::string& orxClass);

    virtual void tick (float time);
    virtual void draw() const;

    void debugDraw() const;

    inline const Vector& getCenter() { return this->_center; }

    void mount(PNode* entity);
    void unmount();
    PNode* getMount() { return this->_mount; }

  private:
    PNode*               _mount;       //!< the entity mounted at this mount point
    std::string          _name;        //!< the name of the mount point

    std::string          _description; //!< string containing an optional description

    Vector               _center;
    Vector               _up;
    Vector               _forward;

};

#endif /* _MOUNT_POINT_H */
