#ifndef _CAMERAMAN_H
#define _CAMERAMAN_H


#include <vector>
#include "base_object.h"

class BlackScreen;
class Camera;
class PNode;

class CameraMan : public BaseObject {
  ObjectListDeclaration(CameraMan);

  private:
    Camera* currentCam;
    float nearClip;
    float farClip;
    BlackScreen* fadeToBlack;

  public:
    std::vector<Camera*> cameras;
    CameraMan(const TiXmlElement* root = NULL);
    void setCam(unsigned int CameraNo);
    void setCam(const std::string& camName);
    void setCam(Camera* camera);

    /// LOADING
    virtual void loadParams(const TiXmlElement* root);
    void createCameras(const TiXmlElement* camerasTag);
    void createCam(const TiXmlElement* root);

    /// POLLING
    float getCurrCameraCoorX();
    float getCurrCameraCoorY();
    float getCurrCameraCoorZ();
    const Camera* getCurrentCam() const { return this->currentCam; }
    Camera* getCurrentCam() { return this->currentCam; }

    
    /// Current camera
    void moveCurrCam(int x, int y, int z);
    void changeCurrTarget(const std::string& className, const std::string& objectName);
    void atachCurrCameraToWorldEntity(const std::string& className, const std::string& targetEntity);
    void detachCurrCamera();
    void jumpCurrCam(float x, float y, float z);
    void togglFade();
    void initFadeBlack();
    
    /// Camera
    void moveCam(int x, int y, int z,  int camNo);
    void changeTarget(int camNo, const std::string& className,const std::string& objectName);
    void changeTarget(const std::string& camName,const std::string& className, const std::string& objectName);
    void atachCameraToWorldEntity(const std::string& cameraName, const std::string& className, const std::string& targetEntity);
    void jumpCam(int x, int y, int z, int camNo);
    void jumpCam(const std::string& cameraName, float x, float y, float z);
    void setRelCameraCoor(const std::string& cameraName, float x, float y, float z);
    void setRelCameraCoorSoft(const std::string& cameraName, float x, float y, float z, float bias);
    //void setViewMode(const std::string& camName, const std::string& viewMode);
    void pauseCamera(const std::string& camName, bool stop);
    
    void changeSpeed(float speed);
    void setClipRegion(float nearClip, float farClip);
    void cameraInfo();
    
  private:
    bool cameraIsInVector(Camera* camera);
    void atachTarget(Camera* cam, PNode* pnode);
    

};

#endif /* _CAMERAMAN_H */
