  /*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Filip Gospodinov
   co-programmer: Silvan Nellen
*/

#include "shell_command.h"
#include "cameraman.h"
#include "game_world_data.h"
#include "state.h"
#include "sound_engine.h"
#include <string>
#include "script_class.h"
#include "loading/load_param_xml.h"
#include "blackscreen.h"
#include "p_node.h"
#include "camera.h"

ObjectListDefinition(CameraMan);

SHELL_COMMAND(camerainfo, CameraMan, cameraInfo);


CREATE_SCRIPTABLE_CLASS(CameraMan,
                        addMethod("changeCurrTarget", Executor2<CameraMan, lua_State*,const std::string&,const std::string&>(&CameraMan::changeCurrTarget))
                        ->addMethod("atachCurrCameraToWorldEntity", Executor2<CameraMan, lua_State*,const std::string&,const std::string&>(&CameraMan::atachCurrCameraToWorldEntity))
                        ->addMethod("changeTarget", Executor3<CameraMan, lua_State*, const std::string&, const std::string&,const std::string&>(&CameraMan::changeTarget))
                        ->addMethod("atachCameraToWorldEntity", Executor3<CameraMan, lua_State*,const std::string&,const std::string&,const std::string&>(&CameraMan::atachCameraToWorldEntity))
                        ->addMethod("detachCurrCamera", Executor0<CameraMan, lua_State*>(&CameraMan::detachCurrCamera))
                        ->addMethod("setCam", Executor1<CameraMan, lua_State*, const std::string&>(&CameraMan::setCam))
                        ->addMethod("toggleFade", Executor0<CameraMan, lua_State*>(&CameraMan::togglFade))
                        ->addMethod("initFadeBlack", Executor0<CameraMan, lua_State*>(&CameraMan::initFadeBlack))
                        ->addMethod("getCurrCameraCoorX", Executor0ret<CameraMan, lua_State*,float>(&CameraMan::getCurrCameraCoorX))
                        ->addMethod("getCurrCameraCoorY", Executor0ret<CameraMan, lua_State*,float>(&CameraMan::getCurrCameraCoorY))
                        ->addMethod("getCurrCameraCoorZ", Executor0ret<CameraMan, lua_State*,float>(&CameraMan::getCurrCameraCoorZ))
                        ->addMethod("jumpCurrCam", Executor3<CameraMan, lua_State*,float,float,float>(&CameraMan::jumpCurrCam))
                        ->addMethod("jumpCam", Executor4<CameraMan, lua_State*,const std::string&,float,float,float>(&CameraMan::jumpCam))
                        //->addMethod("setViewMode", Executor2<CameraMan, lua_State*,const std::string&,const std::string&>(&CameraMan::setViewMode))
                        ->addMethod("setRelCoor", Executor4<CameraMan, lua_State*,const std::string&,float,float,float>(&CameraMan::setRelCameraCoor))
                        ->addMethod("setRelCoorSoft", Executor5<CameraMan, lua_State*,const std::string&,float,float,float,float>(&CameraMan::setRelCameraCoorSoft))
                        ->addMethod("pauseCamera", Executor2<CameraMan, lua_State*, const std::string&, bool>(&CameraMan::pauseCamera))
                       );


CameraMan::CameraMan(const TiXmlElement* root)
{
  this->registerObject(this, CameraMan::_objectList);

  this->nearClip = 1.0;
  this->farClip = 1000.0;

  this->fadeToBlack=new BlackScreen();

  this->setCam( State::getCamera());

  if (root != NULL)
    this->loadParams(root);
}


void CameraMan::loadParams(const TiXmlElement* root)
{
  BaseObject::loadParams(root);
  LoadParamXML(root, "Cameras", this, CameraMan, createCameras);
}


void CameraMan::createCameras(const TiXmlElement* camerasTag)
{

    LOAD_PARAM_START_CYCLE(camerasTag, object);
    {
      this->createCam(object);
    }
    LOAD_PARAM_END_CYCLE(object);

}


void CameraMan::createCam(const TiXmlElement* root)
{
  this->cameras.push_back(new Camera(root));
  cameras[cameras.size()-1]->setClipRegion(nearClip, farClip);
}

/*void CameraMan::setViewMode(const std::string& cameraName, const std::string& viewMode)
{
     BaseObject* newCam = ObjectListBase::getBaseObject("Camera", cameraName);
     
     if (!strcmp(viewMode, "ViewNormal"))
     {
         dynamic_cast<Camera*>(newCam)->setViewMode(Camera::ViewNormal);
     }
     else if (!strcmp(viewMode, "ViewTop"))
     {
         dynamic_cast<Camera*>(newCam)->setViewMode(Camera::ViewTop);
     }
     else if (!strcmp(viewMode, "ViewBehind"))
     {
         dynamic_cast<Camera*>(newCam)->setViewMode(Camera::ViewBehind);
     }
     else if (!strcmp(viewMode, "ViewFront"))
     {
         dynamic_cast<Camera*>(newCam)->setViewMode(Camera::ViewFront);
     }
     else if (!strcmp(viewMode, "ViewLeft"))
     {
         dynamic_cast<Camera*>(newCam)->setViewMode(Camera::ViewLeft);
     }
     else if (!strcmp(viewMode, "ViewRight"))
     {
         dynamic_cast<Camera*>(newCam)->setViewMode(Camera::ViewRight);
     }
}*/

void CameraMan::setRelCameraCoor(const std::string& camName, float x, float y, float z)
{
     BaseObject* newCam = ObjectListBase::getBaseObject("Camera", camName);
     dynamic_cast<Camera*>(newCam)->setRelCoor(x,y,z);
     dynamic_cast<Camera*>(newCam)->target->setRelCoor(0,0,0);
}

void CameraMan::setRelCameraCoorSoft(const std::string& camName, float x, float y, float z, float bias)
{
     BaseObject* newCam = ObjectListBase::getBaseObject("Camera", camName);
     dynamic_cast<Camera*>(newCam)->setRelCoorSoft(x,y,z,bias);
     dynamic_cast<Camera*>(newCam)->target->setRelCoorSoft(0,0,0,bias);
}

void CameraMan::pauseCamera(const std::string& camName, bool stop)
{
     BaseObject* newCam = ObjectListBase::getBaseObject("Camera", camName);
     dynamic_cast<Camera*>(newCam)->pauseTrack(stop);
}

void CameraMan::setCam(unsigned int cameraNo)
{
  if (cameraNo<cameras.size())
  {
    this->setCam( cameras[cameraNo]);
  }
}

void CameraMan::setCam(const std::string& camName)
{
  BaseObject* object = ObjectListBase::getBaseObject("Camera", camName);

  if(object != NULL)
  {
    this->setCam(dynamic_cast<Camera*>(object));
    return;
  }
  printf("ERROR CAMERAMANAGER: Couldn't set camera : %s \n", camName.c_str());
}


void CameraMan::setCam(Camera* camera)
{
  if( camera == NULL)
  {
    PRINTF(0)("trying to add a zero camera! uiuiui!\n");
    return;
  }
  
  this->currentCam = camera;

  State::setCamera(currentCam, currentCam->getTarget());
  OrxSound::SoundEngine::getInstance()->setListener(currentCam);

  // check if it is already added
  if( ! this->cameraIsInVector(currentCam) )
    this->cameras.push_back(currentCam);

  this->fadeToBlack->setRelCoor(0., 0., 0.);
  this->fadeToBlack->setParent(this->currentCam);
}


void CameraMan::moveCurrCam(int x, int y, int z)
{
  currentCam->target->trans(x,y,z);
}


void CameraMan::changeCurrTarget(const std::string& className, const std::string& objectName)
{
  BaseObject* object = ObjectListBase::getBaseObject(className, objectName);
  if( object != NULL && object->isA(PNode::staticClassID()))
  {
    currentCam->lookAt(dynamic_cast<PNode*>(object));
    State::setCamera(this->currentCam,  dynamic_cast<CameraTarget*>(object));
  }
}


void CameraMan::atachCurrCameraToWorldEntity(const std::string& className, const std::string& targetEntity)
{
  BaseObject* object = ObjectListBase::getBaseObject(className, targetEntity);

  if(object != NULL && object->isA(PNode::staticClassID()))
  {
   this->atachTarget(this->currentCam, dynamic_cast<PNode*>(object));
   return;
  }

printf("ERROR CAMERAMANAGER: Couldn't set camera to: %s %s \n", className.c_str(),targetEntity.c_str() );
}



void CameraMan::detachCurrCamera()
{
  currentCam->target->detach();
}



void CameraMan::jumpCurrCam(float x, float y, float z)
{
  currentCam->target->jump(x, y, z);
}

void CameraMan::togglFade()
{
  if( this->fadeToBlack)
    fadeToBlack->toggleFade();
}


void CameraMan::initFadeBlack()
{
  if( this->fadeToBlack)
    fadeToBlack->initFadeBlack();
}


void CameraMan::moveCam(int x, int y, int z, int camNo)
{
  cameras[camNo]->target->trans(x,y,z);
}


void CameraMan::changeTarget(int camNo,const std::string& className, const std::string& objectName)
{
  BaseObject* object = ObjectListBase::getBaseObject(className, objectName);
  if( object != NULL && object->isA(PNode::staticClassID()))
  {
    cameras[camNo]->lookAt(dynamic_cast<PNode*>(object));
  }
}


void CameraMan::changeTarget(const std::string& camName,const std::string& className, const std::string& objectName)
{
  BaseObject* object = ObjectListBase::getBaseObject(className, objectName);
  BaseObject* newCam = ObjectListBase::getBaseObject("Camera", camName);
  if( object != NULL && newCam != NULL && object->isA(PNode::staticClassID()))
  {
    dynamic_cast<Camera*>(newCam)->lookAt(dynamic_cast<PNode*>(object));
    State::setCamera( dynamic_cast<Camera*>(newCam),  dynamic_cast<CameraTarget*>(object));
  }
}


void CameraMan::atachCameraToWorldEntity(const std::string& cameraName, const std::string& className, const std::string& targetEntity)
{
  BaseObject* object = ObjectListBase::getBaseObject(className, targetEntity);
  BaseObject* targetCam = ObjectListBase::getBaseObject("Camera", cameraName);

  if( object != NULL && targetCam != NULL && object->isA(PNode::staticClassID()) )
  {
    this->atachTarget(dynamic_cast<Camera*>(targetCam), dynamic_cast<PNode*>( object ));
    return;
  }

  printf("ERROR CAMERAMANAGER: Couldn't set camera %s to: %s %s \n", cameraName.c_str(), className.c_str(),targetEntity.c_str() );
}



void CameraMan::jumpCam(int x, int y, int z, int camNo)
{
  cameras[camNo]->target->jump(x, y, z);
}


void CameraMan::jumpCam(const std::string& cameraName, float x, float y, float z)
{
  BaseObject* targetCam = ObjectListBase::getBaseObject("Camera", cameraName);
  if( targetCam != NULL )
  {
    dynamic_cast<Camera*>(targetCam)->target->jump( x, y, z );
  }

}


void CameraMan::setClipRegion(float nearCli, float farCli)
{
  this->nearClip=nearCli;
  this->farClip=farCli;

  for(unsigned int i = 0; i < this->cameras.size(); i++)
    cameras[i]->setClipRegion(nearCli, farCli);
}



bool CameraMan::cameraIsInVector(Camera* camera)
{

  for(std::vector<Camera*>::const_iterator it = cameras.begin(); it != cameras.end(); it++ )
  {
    if( (*it) == camera)
    {
      return true;
    }
  }
  return false;


}


void CameraMan::cameraInfo()
{
  bool sameCam = (this->currentCam == State::getCamera());


  PRINT(0)("==== CameraMan::cameraInfo ===\n");
  PRINT(0)("=  Camera Name: %s\n", this->currentCam->getName().c_str());
  PRINT(0)("=  Tests:\n");
  PRINT(0)("==  State::Cam == this::Cam  %i\n", sameCam);
  PRINT(0)("==  Parenting Informations:\n");
  this->currentCam->debugNode(10);
  PRINT(0)("==============================\n");
}


float CameraMan::getCurrCameraCoorX()
{ return this->currentCam->getAbsCoorX(); }

float CameraMan::getCurrCameraCoorY()
{ return this->currentCam->getAbsCoorY(); }

float CameraMan::getCurrCameraCoorZ()
{ return this->currentCam->getAbsCoorZ(); }



void CameraMan::atachTarget(Camera* cam ,PNode* target)
{
  cam->target->atach(target);
  cam->setViewMode(Camera::ViewNormal);
  State::setCamera( cam,  dynamic_cast<CameraTarget*>(target));

}

//how to get a class fkt pointer

//BaseObject* object = ObjectListBase::getBaseObject(className, objectName);














