#ifndef _BLACKSCREEN_H
#define _BLACKSCREEN_H

#include "world_entity.h"


class TiXmlElement;
class Material;

class BlackScreen : public WorldEntity
{
    ObjectListDeclaration(BlackScreen);

  private:
    float i;
    bool state;
    Material*       material;
    void fadeIn();
    void fadeOut();
    float fadeSpeed;

  public:
    BlackScreen();
    BlackScreen(const TiXmlElement* root);
    virtual ~BlackScreen();

    void init();
    virtual void loadParams(const TiXmlElement* root);

    void toggleFade();
    void initFadeBlack();
    void changeFadeSpeed(float newSpeed);
    bool isBlack();
    bool isTrans();
    virtual void tick (float time);

    virtual void draw() const;


};

#endif /* _BLACKSCREEN_H */
