

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "npc_test1.h"
#include "obb_tree.h"

#include "state.h"
#include "items/power_ups/turret_power_up.h"
#include "items/power_ups/laser_power_up.h"

ObjectListDefinition(NPCTest1);

NPCTest1::NPCTest1()
  : NPC(NULL)
{
  this->registerObject(this, NPCTest1::_objectList);

  if ((float)rand()/RAND_MAX > .5f)
    this->loadModel("models/ships/bolido.obj", 2);
  else
    this->loadModel("models/ships/gobblin.obj", 2);

  this->randomRotAxis =  VECTOR_RAND(1).getNormalized();
}


NPCTest1::~NPCTest1 () {}



void NPCTest1::tick(float dt)
{
  this->shiftDir(Quaternion(dt, this->randomRotAxis));
}



