/*!
 * @file weapon_power_up.h
 * @brief A class representing a PowerUp containing a weapon.
*/

#ifndef _WEAPON_POWER_UP_H
#define _WEAPON_POWER_UP_H

#include "power_up.h"
#include "weapons/weapon.h"
#include "weapons/weapon_manager.h"

/* FORWARD DEFINITION */

class WeaponPowerUp : public PowerUp {
ObjectListDeclaration(WeaponPowerUp);
public:
  WeaponPowerUp(const TiXmlElement* root = NULL);
  virtual ~WeaponPowerUp ();

  virtual void loadParams(const TiXmlElement* root);

  Weapon* getWeapon();
  void setWeaponClass(const std::string& name);

  bool process(WeaponManager* manager);

private:
  void init();
  void newWeapon();
private:
  Weapon* weapon;
  const TiXmlElement* weaponXML;

  void createWeapon();
};

#endif /* _WEAPON_POWER_UP_H */
