/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY

#include "weapon_power_up.h"
#include "util/loading/factory.h"
#include "state.h"
#include "network_game_manager.h"

#include "primitive_model.h"

#include "util/loading/factory.h"
#include "util/loading/load_param.h"
#include "debug.h"


ObjectListDefinition(WeaponPowerUp);
CREATE_FACTORY(WeaponPowerUp);

WeaponPowerUp::WeaponPowerUp(const TiXmlElement* root) : PowerUp(1.0, 1.0, 0.0)
{
  this->init();
  if( root != NULL)
    this->loadParams(root);
}


WeaponPowerUp::~WeaponPowerUp ()
{
}


void WeaponPowerUp::init()
{
  this->registerObject(this, WeaponPowerUp::_objectList);
  this->loadPickupSound("sounds/powerups/whats this2.wav");

  this->weaponXML = NULL;
  this->weapon = NULL;
}


void WeaponPowerUp::loadParams(const TiXmlElement* root)
{
  PowerUp::loadParams(root);
  const TiXmlElement* elem = root->FirstChildElement("weapon");
  if(elem != NULL && (elem = elem->FirstChildElement()) != NULL)
  {
    this->weaponXML = elem;
    newWeapon();
  }
  else
  {
    LoadParam(root, "weaponID", this, WeaponPowerUp, setWeaponClass);
  }
}

Weapon* WeaponPowerUp::getWeapon()
{
  return this->weapon;
}

bool WeaponPowerUp::process(WeaponManager* manager)
{
  if(manager->addWeapon(this->weapon)) {
    newWeapon();
  }
  else {
    manager->increaseAmmunition(this->weapon->getProjectileType(), this->weapon->getEnergy());
  }
  return true;
}

void WeaponPowerUp::newWeapon()
{
  this->weapon = dynamic_cast<Weapon*>((weaponXML == NULL)
      ? Factory::fabricate((this->weapon->getClassID()))
      : Factory::fabricate((const TiXmlElement*)this->getXmlElem()->FirstChildElement("weapon")));
  this->model = this->weapon->getModel(0);
}

void WeaponPowerUp::setWeaponClass(const std::string& name)
{
  this->weapon = dynamic_cast<Weapon*>(Factory::fabricate(name));
  if (this->weapon == NULL)
  {
    PRINTF(1)("Unable to load Weapon. %s\n", name.c_str());
    this->weapon = dynamic_cast<Weapon*>(Factory::fabricate("Turret"));
  }
  this->model = this->weapon->getModel(0);
}

