/*!
 * @file turret_power_up.h
 * @brief A class representing a PowerUp in the world.
*/

#ifndef _TURRET_POWER_UP_H
#define _TURRET_POWER_UP_H

#include "power_up.h"

/* FORWARD DEFINITION */
class Material;

class TurretPowerUp : public PowerUp {
  ObjectListDeclaration(TurretPowerUp);

 public:
  TurretPowerUp(const TiXmlElement* root = NULL);
  virtual ~TurretPowerUp ();

  virtual void loadParams(const TiXmlElement* root);

  virtual void collidesWith(WorldEntity* entity, const Vector& location);
  virtual void tick(float dt);
  virtual void draw() const;

  private:
   void init();

  private:
   Vector              rotation;
   float               cycle;

   Model*              sphereModel;
   Material*           sphereMaterial;
};

#endif /* _TURRET_POWER_UP_H */
