/*!
 * @file power_up.h
 * @brief A class representing a PowerUp in the world.
*/

#ifndef _POWER_UP_H
#define _POWER_UP_H

#include "world_entity.h"

#include "sound_buffer.h"
#include "sound_source.h"

class Material;

typedef enum PowerUpRespawn {
  RESPAWN_NONE,
  RESPAWN_TIME,
  RESPAWN_size
} PowerUpRespawn;

class PowerUp : public WorldEntity {
  ObjectListDeclaration(PowerUp);

public:
  virtual void loadParams(const TiXmlElement* root);
  void collidesWith (WorldEntity* entity, const Vector& location);

  void loadPickupSound(const std::string& pickupSound);
  void loadRespawnSound(const std::string& respawnSound);

  virtual void draw () const;
  virtual void tick(float dt);
  void setRespawnType(const std::string& type);
  void setRespawnTime(const float respawn);

protected:
  PowerUp(float r, float g, float b);
  virtual ~PowerUp ();

protected:
  Model* model;

private:
  OrxSound::SoundSource  soundSource;
  OrxSound::SoundBuffer  pickupBuffer;
  OrxSound::SoundBuffer  respawnBuffer;
  Material*              sphereMaterial;
  PowerUpRespawn         respawnType;
  float                  respawnTime;
  float                  respawnStart;
  static const char*     respawnTypes[];

  WorldEntity*           collider;
};

#endif /* _POWER_UP_H */
