/*!
 * @file weapon_power_up.h
 * @brief A class representing a PowerUp modifying parameters.
*/

#ifndef _PARAM_POWER_UP_H
#define _PARAM_POWER_UP_H

#include "power_up.h"

/* FORWARD DEFINITION */

typedef enum EnumParamPowerUpType {
  POWERUP_PARAM_SHIELD,
  POWERUP_PARAM_MAX_SHIELD,
  POWERUP_PARAM_HEALTH,
  POWERUP_PARAM_MAX_HEALTH,
  POWERUP_PARAM_size
} EnumParamPowerUpType;

class ParamPowerUp : public PowerUp {
  ObjectListDeclaration(ParamPowerUp);

public:
  ParamPowerUp(const TiXmlElement* root = NULL);
  virtual ~ParamPowerUp ();

  void setValue(float value);
  void setMaxValue(float value);
  void setMinValue(float value);
  void setType(const std::string& type);
  EnumParamPowerUpType getType();
  float getValue();

protected:
  virtual void respawn();

private:
  void init();
  virtual void loadParams(const TiXmlElement* root);

private:
  EnumParamPowerUpType    type;
  float                   value;
  float                   max_value;
  float                   min_value;

  static const char*      paramTypes[];

};

#endif /* _PARAM_POWER_UP_H */
