/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY

#include "param_power_up.h"
#include "util/loading/factory.h"
#include "state.h"

#include "primitive_model.h"

#include "util/loading/factory.h"
#include "util/loading/load_param.h"
#include "network_game_manager.h"



ObjectListDefinition(ParamPowerUp);
CREATE_FACTORY(ParamPowerUp);

const char* ParamPowerUp::paramTypes[] = {
  "shield",
  "max-shield",
  "health",
  "max-health",
};

ParamPowerUp::ParamPowerUp(const TiXmlElement* root) : PowerUp(0.0, 1.0, 0.0)
{
  this->init();
  this->loadPickupSound("sounds/powerups/power_up_6.wav");
  if( root != NULL)
    this->loadParams(root);

  registerVar( new SynchronizeableInt( (int*)&type, (int*)&type, "type", PERMISSION_MASTER_SERVER ) );
  registerVar( new SynchronizeableFloat( &value, &value, "value", PERMISSION_MASTER_SERVER ) );
  registerVar( new SynchronizeableFloat( &max_value, &max_value, "max_value", PERMISSION_MASTER_SERVER ) );
  registerVar( new SynchronizeableFloat( &min_value, &min_value, "min_value", PERMISSION_MASTER_SERVER ) );
}


ParamPowerUp::~ParamPowerUp ()
{
}


void ParamPowerUp::init()
{
  this->registerObject(this, ParamPowerUp::_objectList);
  this->value = 0;
  this->max_value = 0;
  this->min_value = 0;
}


void ParamPowerUp::loadParams(const TiXmlElement* root)
{
  PowerUp::loadParams(root);
  LoadParam(root, "type", this, ParamPowerUp, setType);

  if( root != NULL && root->FirstChildElement("value") != NULL) {

    LoadParam(root, "value", this, ParamPowerUp, setValue);
  }
  else {
    LoadParam(root, "max-value", this, ParamPowerUp, setMaxValue);
    LoadParam(root, "min-value", this, ParamPowerUp, setMinValue);
    respawn();
  }
}

void ParamPowerUp::setValue(float value)
{
  this->value = value;
}

void ParamPowerUp::setType(const std::string& type)
{
  for(int i = 0; i < POWERUP_PARAM_size; ++i) {
    if(type == paramTypes[i]) {
      this->type = (EnumParamPowerUpType)i;
      break;
    }
  }
}

void ParamPowerUp::setMaxValue(float value)
{
  this->max_value = value;
}

void ParamPowerUp::setMinValue(float value)
{
  this->min_value = value;
}

float ParamPowerUp::getValue()
{
  return this->value;
}

EnumParamPowerUpType ParamPowerUp::getType()
{
  return this->type;
}

void ParamPowerUp::respawn()
{
  if(this->min_value != this->max_value)
  {
    this->value = this->min_value + rand() * (this->max_value - this->min_value);
  }
}

