/*!
 * @file laser_power_up.h
 * @brief A class representing a PowerUp in the world.
*/

#ifndef _LASER_POWER_UP_H
#define _LASER_POWER_UP_H

#include "power_up.h"

/* FORWARD DEFINITION */
class Material;

class LaserPowerUp : public PowerUp {
  ObjectListDeclaration(LaserPowerUp);

 public:
  LaserPowerUp();
  LaserPowerUp(const TiXmlElement* root);
  virtual ~LaserPowerUp ();

  virtual void loadParams(const TiXmlElement* root);


  virtual void collidesWith(WorldEntity* entity, const Vector& location);
  virtual void tick(float dt);
  virtual void draw() const;

  private:
   void init();

  private:
   Vector              rotation;
   float               cycle;

   Model*              sphereModel;
   Material*           sphereMaterial;
};

#endif /* _LASER_POWER_UP_H */
