/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY

#include "laser_power_up.h"
#include "util/loading/factory.h"
#include "state.h"
#include "network_game_manager.h"

#include "primitive_model.h"



ObjectListDefinition(LaserPowerUp);
CREATE_FACTORY(LaserPowerUp);

LaserPowerUp::LaserPowerUp () : PowerUp(0.0, 1.0, 0.0)
{
  this->init();
}

LaserPowerUp::LaserPowerUp(const TiXmlElement* root) : PowerUp(0.0, 1.0, 0.0)
{
  this->init();

  this->loadParams(root);
}


LaserPowerUp::~LaserPowerUp ()
{
  delete this->sphereModel;
  delete this->sphereMaterial;
}


void LaserPowerUp::init()
{
  this->registerObject(this, LaserPowerUp::_objectList);
  this->loadModel("models/guns/test_gun.obj", 2.0);

  this->sphereModel = new PrimitiveModel(PRIM_SPHERE, 7, 5);
  this->sphereMaterial = new Material;
  this->sphereMaterial->setTransparency(.1);
  this->sphereMaterial->setDiffuse(.7, .7, .1);

  this->rotation = Vector(0,1,0);
  this->cycle    = (float)rand()/RAND_MAX*M_2_PI;
  this->shiftDir(Quaternion((float)rand()/RAND_MAX*M_2_PI, this->rotation));
}


void LaserPowerUp::loadParams(const TiXmlElement* root)
{
  PowerUp::loadParams(root);

}


/**
 * this function is called, when two entities collide
 * @param entity: the world entity with whom it collides
 *
 * Implement behaviour like damage application or other miscellaneous collision stuff in this function
 */
void LaserPowerUp::collidesWith(WorldEntity* entity, const Vector& location)
{
 // PRINTF(3)("collision %s vs %s @ (%f,%f,%f)\n", this->getClassCName(), entity->getClassCName(), location.x, location.y, location.z);
  if (entity->isA(Playable::staticClassID()))
  this->toList(OM_DEAD);
}

/**
 *  this method is called every frame
 * @param time: the time in seconds that has passed since the last tick
 *
 * Handle all stuff that should update with time inside this method (movement, animation, etc.)
*/
void LaserPowerUp::tick(float dt)
{
  this->shiftDir(Quaternion(dt, this->rotation));
  this->cycle+=dt;

}

/**
 *  the entity is drawn onto the screen with this function
 *
 * This is a central function of an entity: call it to let the entity painted to the screen.
 * Just override this function with whatever you want to be drawn.
*/
void LaserPowerUp::draw() const
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  /* translate */
  glTranslatef (this->getAbsCoor ().x,
                this->getAbsCoor ().y + cos(this->cycle*3.0)*2.0,
                this->getAbsCoor ().z);
  /* rotate */
  Vector tmpRot = this->getAbsDir().getSpacialAxis();
  glRotatef (this->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );
  this->getModel()->draw();

  this->sphereMaterial->select();
  this->sphereModel->draw();
  glPopMatrix();
}


