/*!
 * @file extendable.h
 * @brief Interface for Worldentities that can pick up powerups.
*/

#ifndef _EXTENDABLE_H
#define _EXTENDABLE_H

#include "base_object.h"

// FORWARD DECLARATION
class PowerUp;


#include "items/power_ups/power_up.h"
//! A class for Extendable Entities
class Extendable : virtual public BaseObject {
  ObjectListDeclaration(Extendable);

  public:
   virtual bool pickup(PowerUp* powerUp) { return false; };

  protected:
    Extendable() { this->registerObject(this, Extendable::_objectList); };
};

#endif /* _EXTENDABLE_H */
