/*!
 * @file terrain.h
  *  Defines and handles the terrain of the World

    @todo implement it

    The terrain should either be build from a Model a OBJModel or from a HeightMap.
*/

#ifndef _TERRAIN_H
#define _TERRAIN_H

#include "world_entity.h"

// FORWARD DECLARATION
class SpatialSeparation;
class HeightMap;
class Material;

//! A simple method to call a desired debug world.
enum DebugTerrain {TERRAIN_DAVE, TERRAIN_BENSCH};


//! A Class to handle Terrain of orxonox
class Terrain : public WorldEntity
{
  ObjectListDeclaration(Terrain);

 public:
  Terrain(const TiXmlElement* root = NULL);
  Terrain(const std::string& fileName);
  Terrain(DebugTerrain debugTerrain);
  virtual ~Terrain();

  void init();
  virtual void loadParams(const TiXmlElement* root);

  void loadVegetation(const std::string& vegetationFile);

  void loadHeightMap(const std::string& heightMapFile, const std::string& colorMap);
  void loadTexture(const std::string& textureName);
  void setScale(float x, float y, float z);

  void buildDebugTerrain(DebugTerrain debugTerrain);

  float getHeight(float x, float y);
  virtual void draw() const;

  public:
    SpatialSeparation* ssp;

 private:
   Model*              vegetation;
   int                 modelList;

   HeightMap*          heightMap;
   Material*           heightMapMaterial;
   Vector              terrainScale;
};

#endif /* _TERRAIN_H */
