/*!
 * @file skysphere.h
  *  Definition of the Skysphere, that handles the Display of an atmosphere of orxonox.

    A SkySphere is always centered at the current working Camera, and will only obey the cameras
    movment but not its rotation.

    @todo self-rotation
    @todo handle reference to parent-object
*/

#ifndef _SKYSPHERE_H
#define _SKYSPHERE_H

/* INCLUDES */
#include "world_entity.h"
#include "glincl.h"

/* FORWARD DECLARATION */
class Material;
class Vector;

//! A Class to handle a SkySphere
class Skysphere : public WorldEntity
{
  ObjectListDeclaration(Skysphere);

 public:
  Skysphere(char* fileName = NULL);
  virtual ~Skysphere();

  void setRadius(float radius);
  void setTexture(char* fileName);

  virtual void draw() const;

  private:
    void initialize(char* fileName);

 private:
  GLUquadricObj*    sphereObj;           //!< A Placeholder for the SkySphere.
  Material*         skyMaterial;         //!< A Material for the SkySphere.
  float             sphereRadius;        //!< Radius of the SkySphere. This should match the frustum maximum range.
};

#endif  /* _SKYSPHERE_H */



