/*!
 * @file skydome.h
 */

#ifndef _SKYDOME_H
#define _SKYDOME_H

/* INCLUDES */
#include "world_entity.h"
#include "shader.h"

//   typedef struct VERTEX
// {
//   float x,y,z;
//   unsigned int color;
//   float u, v;
// }  ;


//! A Class to handle a SkyDome
class Skydome : public WorldEntity
{
  ObjectListDeclaration(Skydome);
public:
  Skydome();

  virtual ~Skydome();

  void init();
  virtual void draw() const;

  void generateSkyPlane(int divisions, float planetRadius, float atmosphereRadius,
                        float hTile, float vTile);

  void setShader(Shader* shader);
  void setTexture(GLuint texture);

  void activate();
  void deactivate();

private:

  typedef struct VertexInfo
  {
    float x,y,z;
    unsigned int color;
    float u, v;
  };

  bool activateDome;

  VertexInfo *planeVertices;
  int numPlaneVertices;

  int *indices;
  int numIndices;

  float pRadius;

  VertexInfo *vertices;
  int numVertices;

  GLuint texture;
  Shader* shader;
};

#endif  /* _SKYDOME_H */
