/*!
  \file environment.h
  \brief This file handles the environment of the game
*/

#ifndef _ENVIRONEMENT_H
#define _ENVIRONEMENT_H

#include "world_entity.h"

//! environment of orxonox
/**
   everything that does not interact with the player comes here
   Environment is a container for all the worldEntities that are non-interactive
*/
class Environment : public WorldEntity
{
  ObjectListDeclaration(Environment);

 public:
  Environment ();
  Environment (const TiXmlElement* root);
  virtual ~Environment ();

  void init();
  virtual void loadParams(const TiXmlElement* root);



  virtual void tick (float time);

};

#endif /* _ENVIRONEMENT_H */
