

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "environment.h"

#include "obj/objModel.h"
#include "obb_tree.h"
#include "util/loading/factory.h"


ObjectListDefinition(Environment);
CREATE_FACTORY(Environment);

/**
 *  creates an environment
*/
Environment::Environment () : WorldEntity()
{
  this->init();
  this->loadModel("models/ships/bolido.obj");
//   if(this->obbTree == NULL)
//     this->obbTree = new OBBTree(4, (sVec3D*)this->model->getVertexArray(), this->model->getVertexCount());
}

/**
 * create an environment out of a XML-element
 * @param root the XML-element to load the Environment from
 */
Environment::Environment(const TiXmlElement* root)
{
  this->init();
  if (root != NULL)
    this->loadParams(root);
}

/**
 *  deletes an environment
*/
Environment::~Environment ()
{}

/**
 * initialize an Environment
 */
void Environment::init()
{
  this->registerObject(this, Environment::_objectList);
  this->toList(OM_ENVIRON);
}

/**
 * loads the Settings of an Environment from an XML-element.
 * @param root the XML-element to load the ELements properties from
 */
void Environment::loadParams(const TiXmlElement* root)
{
  WorldEntity::loadParams(root);
}


/**
 *  ticks the environment
 * @param time the time about which to tick
*/
void Environment::tick (float time) {}


