/*!
 * @file bsp_entity.h
 * @brief description
*/

#ifndef _BSP_ENTITY_H
#define _BSP_ENTITY_H

#include "world_entity.h"
#include "bsp/bsp_manager.h"

#include "util/loading/factory.h"
#include "util/loading/load_param.h"



//! A Class to ...
class BspEntity : public WorldEntity
{
  ObjectListDeclaration(BspEntity);
 public:
  BspEntity(const TiXmlElement* root = NULL);
  virtual ~BspEntity();

  virtual void loadParams(const TiXmlElement* root);

  void setName(const std::string& name);
  void setTransparency(int sort, int sortMore = 0);

  void init();

  virtual void varChangeHandler( std::list<int> & id );

  virtual void draw() const;
  virtual void tick(float time);
  virtual void collidesWith (WorldEntity* entity, const Vector& location);

  /** @returns the BspManager of this entity */
  inline BspManager* getBspManager() { return this->bspManager; }

 private:
   BspManager* bspManager;

   std::string name;                   //!< store name
   std::string name_write;             //!< temp variable to store name
   int name_handle;                    //!< handle for name
   int sortTransparency;              //!< sort transparent textures
   int sortTransparencyMore;          //!< sort transparent textures better
};

#endif /* _BSP_ENTITY_H */
