/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Claudio Botta
   co-programmer: ...
*/

#include "bsp_entity.h"

#include "debug.h"
#include "loading/resource_manager.h"


ObjectListDefinition(BspEntity);
CREATE_FACTORY(BspEntity);


/**
 * constructs and loads a BspEntity from a XML-element
 * @param root the XML-element to load from
 */
BspEntity::BspEntity(const TiXmlElement* root)
{
  this->init();

  if (root != NULL)
    this->loadParams(root);
}


/**
 * standard deconstructor
 */
BspEntity::~BspEntity ()
{
  if( this->bspManager != NULL)
    delete this->bspManager;
}



/**
 * initializes the BspEntity
 * @todo change this to what you wish
 */
void BspEntity::init()
{
  this->registerObject(this, BspEntity::_objectList);

  this->bspManager = NULL;
  this->sortTransparency = 1;
  this->sortTransparencyMore = 0;


  this->name_handle = registerVarId( new SynchronizeableString( &this->name, &this->name_write, "name", PERMISSION_MASTER_SERVER ) );

  this->setSynchronized( true );
}


void BspEntity::setName(const std::string& name)
{
  PRINTF(0)("+++++++++++ LOADING NAME %s\n", name.c_str());

  this->name = name;

  // Check wether file exists....
  if ( File(Resources::ResourceManager::getInstance()->prependAbsoluteMainPath(name)).exists()  ) {

    this->bspManager = new BspManager(this);
    this->bspManager->sortTransparency = this->sortTransparency;
    this->bspManager->sortTransparencyMore = this->sortTransparencyMore;

    if(this->bspManager->load(name.c_str(), 0.1f) == -1 ) {
      this->bspManager = NULL;

    } else {
      this->toList(OM_ENVIRON); // Success!!!
    }
  } else {
    this->bspManager = NULL;
    this->toList(OM_DEAD);
  }
}

void BspEntity::setTransparency(int sort, int sortMore)
{
  this->sortTransparency = sort;
  this->sortTransparencyMore = sortMore;
  
  if (this->bspManager != NULL)
  {
    this->bspManager->sortTransparency = sort;
    this->bspManager->sortTransparencyMore = sortMore;
  }
}

/**
 * loads a BspEntity from a XML-element
 * @param root the XML-element to load from
 * @todo make the class Loadable
 */
void BspEntity::loadParams(const TiXmlElement* root)
{
  // all the clases this Entity is directly derived from must be called in this way, to load all settings.
  // WorldEntity::loadParam(root);

  LoadParam(root, "Name", this, BspEntity, setName)
  .describe("Sets the of the BSP file.");

  LoadParam(root, "Transparency", this, BspEntity, setTransparency)
  .describe("1. argument: true -> sort transparent textures; 2. argument: true -> better but slower sorting")
  .defaultValues(1, 0);
  
  /*  LoadParam(root, "Scale", this, BSpEntity, setScale)
        .describe("Sets the scale factore of the bsp level.");
  */

  /**
   * @todo: make the class Loadable
   */
}


/**
 * advances the BspEntity about time seconds
 * @param time the Time to step
 */
void BspEntity::tick(float time)
{
  this->bspManager->tick(time);
}


/**
 * draws this worldEntity
 */
void BspEntity::draw () const
{
  this->bspManager->draw();
}


/**
 *
 *
 */
void BspEntity::collidesWith (WorldEntity* entity, const Vector& location)
{}

void BspEntity::varChangeHandler( std::list< int > & id )
{
  if ( std::find( id.begin(), id.end(), this->name_handle ) != id.end() )
  {
    this->setName( this->name_write );
  }
}
