/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Silvan Nellen
   co-programmer: Benjamin Grauer
*/


#include <string>
#include <list>

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD


#include "script_manager.h"
#include "lunar.h"

#include "script.h"
#include "tools/script_trigger.h"
#include "luaincl.h"
#include "loading/load_param_xml.h"



ScriptManager::ScriptManager(const TiXmlElement* root)
{
  this->setName("ScriptManager");

  if (root != NULL)
    this->loadParams(root);
}



ScriptManager::~ScriptManager()
{
  this->flush();
}


void ScriptManager::loadParams(const TiXmlElement* root)
{
  BaseObject::loadParams(root);
  {
    LoadParamXML(root, "Scripts", this, ScriptManager, createScripts);

    LoadParamXML(root, "ScriptTriggers", this, ScriptManager, createTriggers);
  } // make shure that the loading process is finished

  // fill the scripts and triggers (doing that on runtime is very slow!)
}



void  ScriptManager::flush()
{
  //Delete all scripts as they aren't deleted automatically
  while(!Script::objectList().empty())
    delete Script::objectList().front();
  //Delete all triggers
  while(!ScriptTrigger::objectList().empty())
    delete ScriptTrigger::objectList().front();

}

void  ScriptManager::createScripts(const TiXmlElement* scripts)
{

  LOAD_PARAM_START_CYCLE(scripts, object);
  {
    new Script(object);
  }
  LOAD_PARAM_END_CYCLE(object);

}

void ScriptManager::createTriggers(const TiXmlElement* triggers)
{
  LOAD_PARAM_START_CYCLE(triggers, object);
  {
    new ScriptTrigger(object);
  }
  LOAD_PARAM_END_CYCLE(object);

}


Script* ScriptManager::getScriptByFile(const std::string& file)
{
  for (ObjectList<Script>::const_iterator it = Script::objectList().begin();
       it != Script::objectList().end();
       ++it)
    if( ((*it))->getFileName().compare(file) == 0)
      return (*it);

  return NULL;

}
