

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "movement_module.h"
#include "ai_module.h"
#include "ai_team.h"
#include "ai_swarm.h"
#include "ai_engine.h"

#include "player.h"
#include "playable.h"

#include "weapons/test_gun.h"
#include "weapons/turret.h"
#include "weapons/cannon.h"

#include "loading/factory.h"
#include "debug.h"
#include "loading/load_param.h"
#include "util/loading/load_param_xml.h"
#include "track/track.h"

#include "particles/dot_emitter.h"
#include "particles/emitter_node.h"
#include "particles/sprite_particles.h"

#include "weapons/test_gun.h"
#include "weapons/light_blaster.h"
#include "weapons/medium_blaster.h"
#include "weapons/heavy_blaster.h"
#include "weapons/swarm_launcher.h"
#include "weapons/spike_thrower.h"
#include "weapons/acid_launcher.h"
#include "weapons/boomerang_gun.h"
#include "weapons/turret.h"
#include "weapons/cannon.h"

#include "mount_point.h"
#include "weapons/weapon_slot.h"

#include "npc.h"

ObjectListDefinition(NPC);
CREATE_FACTORY(NPC);


#include "script_class.h"
CREATE_SCRIPTABLE_CLASS(NPC,
                        addMethod("getAbsCoorX", Executor0ret<PNode, lua_State*, float>(&PNode::getAbsCoorX))
                        ->addMethod("getAbsCoorY", Executor0ret<PNode, lua_State*, float>(&PNode::getAbsCoorY))
                        ->addMethod("getAbsCoorZ", Executor0ret<PNode, lua_State*, float>(&PNode::getAbsCoorZ))
                        ->addMethod("setAbsCoor", Executor3<PNode, lua_State*,float,float,float>(&PNode::setAbsCoor))
                        ->addMethod("setAbsDir", Executor4<PNode, lua_State*,float,float,float,float>(&PNode::setAbsDir))
                        ->addMethod("fire", Executor0<NPC, lua_State*>(&NPC::fire))
                        ->addMethod("pause", Executor1<WorldEntity, lua_State*, bool>(&WorldEntity::pauseTrack))
                        ->addMethod("setAI", Executor1<NPC, lua_State*, bool>(&NPC::setAI))
                        ->addMethod("setVisibility", Executor1<WorldEntity, lua_State*, bool>(&WorldEntity::setVisibility))
                        ->addMethod("destroy", Executor0<NPC, lua_State*/*, WorldEntity**/>(&NPC::destroyThis))
                       );

NPC::NPC(const TiXmlElement* root)
  : weaponMan(this)
{
  this->registerObject(this, NPC::_objectList);

  this->toList(OM_GROUP_00);
  this->bAIEnabled = false;



   // create the weapons and their manager
  Weapon* wpRight1 = new LightBlaster ();
  wpRight1->setName( "LightBlaster");
  Weapon* wpLeft1 = new LightBlaster ();
  wpLeft1->setName( "LightBlaster");

  Weapon* wpRight2 = new MediumBlaster ();
  wpRight2->setName( "MediumBlaster");
  Weapon* wpLeft2 = new MediumBlaster ();
  wpLeft2->setName( "MediumBlaster");

  Weapon* wpRight3 = new HeavyBlaster (1);
  wpRight3->setName( "HeavyBlaster");
  Weapon* wpLeft3 = new HeavyBlaster (0);
  wpLeft3->setName( "HeavyBlaster");

  Weapon* cannon = new SwarmLauncher();
  cannon->setName( "SwarmLauncher");

  Weapon* spike = new SpikeThrower();
  spike->setName( "SpikeThrower" );


  Weapon* acid0 = new AcidLauncher();
  acid0->setName( "AcidSplasher" );

  Weapon* acid1 = new AcidLauncher();
  acid1->setName( "AcidSplasher" );


  this->weaponMan.addWeapon( wpLeft1, 0, 0);
  this->weaponMan.addWeapon( wpRight1, 0, 1);

  this->weaponMan.addWeapon( wpLeft2, 1, 2);
  this->weaponMan.addWeapon( wpRight2, 1, 3);

  this->weaponMan.addWeapon( wpLeft3, 2, 4);
  this->weaponMan.addWeapon( wpRight3, 2, 5);
/*
  this->weaponMan.addWeapon( wpLeft1, 3, 0);
  this->weaponMan.addWeapon( wpRight1, 3, 1);

  this->weaponMan.addWeapon( wpLeft2, 3, 2);
  this->weaponMan.addWeapon( wpRight2, 3, 3);

  this->weaponMan.addWeapon( wpLeft3, 3, 4);
  this->weaponMan.addWeapon( wpRight3, 3, 5);
*/

  this->weaponMan.addWeapon( acid0, 3, 0);
  this->weaponMan.addWeapon( acid1, 3, 1);


  if( root != NULL)
    this->loadParams(root);

  if( this->bAIEnabled && ! this->entityTrack)
  {
    std::cout << "Team Number: " << teamNumber << "\n";
    std::cout << "Swarm Number:" << swarmNumber << "\n";

    AIEngine::getInstance()->addAI(teamNumber,swarmNumber,(WorldEntity*)this,maxSpeed,attackDistance);
  }

  this->bFire = false;
  if( this->entityTrack)
  {
      this->setParent(this->entityTrack->getTrackNode());
      this->setRelCoor(0,0,0);
  }




//   this->secWeaponMan.addWeapon( acid0, 2, 2);
//   this->secWeaponMan.addWeapon( acid1, 2, 3);


//   this->weaponMan.changeWeaponConfig(3);

//   this->getWeaponManager().changeWeaponConfig(1);

  this->setHealthMax(100);
  this->setHealth(80);

  this->getWeaponManager().setSlotCount(7);

  this->getWeaponManager().setSlotPosition(0, Vector(-2.6, .1, -3.0));
  this->getWeaponManager().setSlotCapability(0, WTYPE_ALLDIRS | WTYPE_DIRECTIONAL);

  this->getWeaponManager().setSlotPosition(1, Vector(-2.6, .1, 3.0));
  this->getWeaponManager().setSlotCapability(1, WTYPE_ALLDIRS | WTYPE_DIRECTIONAL);

  this->getWeaponManager().setSlotPosition(2, Vector(-1.5, .5, -.5));
  this->getWeaponManager().setSlotDirection(2, Quaternion(-M_PI_4*.5, Vector(1,0,0)));

  this->getWeaponManager().setSlotPosition(3, Vector(-1.5, .5, .5));
  this->getWeaponManager().setSlotDirection(3, Quaternion(M_PI_4*.5, Vector(1,0,0)));

  this->getWeaponManager().setSlotPosition(4, Vector(-1.5, -.5, .5));
  this->getWeaponManager().setSlotDirection(4, Quaternion(-M_PI_4*.5+M_PI, Vector(1,0,0)));

  this->getWeaponManager().setSlotPosition(5, Vector(-1.5, -.5, -.5));
  this->getWeaponManager().setSlotDirection(5, Quaternion(+M_PI_4*.5-M_PI, Vector(1,0,0)));

  this->getWeaponManager().setSlotPosition(6, Vector(-1, 0.0, 0));
  this->getWeaponManager().setSlotCapability(6, WTYPE_ALLDIRS | WTYPE_DIRECTIONAL);



  this->getWeaponManager().getFixedTarget()->setParent(this);
  this->getWeaponManager().getFixedTarget()->setRelCoor(100000,0,0);
  this->bInit = false;
}


NPC::~NPC ()
{
 if(! this->entityTrack)
  AIEngine::getInstance()->removeAI(teamNumber,swarmNumber,(WorldEntity*)this);
}



/**
 * loads the xml tags
 * @param root: root xml tag for this element
 */
void NPC::loadParams(const TiXmlElement* root)
{
   WorldEntity::loadParams(root);

  LoadParam(root, "enableAI", this, NPC, enableAI)
      .describe("enables the AI algorithms");

  LoadParam(root, "team", this, NPC, setTeamNumber)
  .describe("this sets the team number")
  .defaultValues(0);

  LoadParam(root, "swarm", this, NPC, setSwarmNumber)
  .describe("this sets the swarm number")
  .defaultValues(0);

  LoadParam(root, "maxSpeed", this, NPC, setMaxSpeed)
  .describe("this sets the NPC max Speed")
  .defaultValues(0);

  LoadParam(root, "attackDistance", this, NPC, setAttackDistance)
  .describe("this sets the NPC distance to target")
  .defaultValues(0);

  LoadParam(root, "weapon-config", this, NPC, setWeaponConfig);

//   LoadParamXML(root, "Weapons", this, NPC, addWeapons)
//   .describe("creates and adds weapons");
}

void NPC::setAI(bool activate)
{
     if(activate) AIEngine::getInstance()->addAI(teamNumber,swarmNumber,(WorldEntity*)this,maxSpeed,attackDistance);
     else AIEngine::getInstance()->removeAI(teamNumber,swarmNumber,(WorldEntity*)this);
}

void NPC::destroy( WorldEntity* killer )
{

  PRINTF(5)("NPC destroy\n");

  EmitterNode* node  = NULL;
  DotEmitter* emitter = NULL;
  SpriteParticles*  explosionParticles  = NULL;

  explosionParticles = new SpriteParticles(200);
  explosionParticles->setName("SpaceShipExplosionParticles");
  explosionParticles->setLifeSpan(.2, .3);
  explosionParticles->setRadius(0.0, 10.0);
  explosionParticles->setRadius(.5, 6.0);
  explosionParticles->setRadius(1.0, 3.0);
  explosionParticles->setColor(0.0, 1,1,1,.9);
  explosionParticles->setColor(0.1,  1,1,0,.9);
  explosionParticles->setColor(0.5, .8,.4,0,.5);
  explosionParticles->setColor(1.0, .2,.2,.2,.5);


  emitter = new DotEmitter( 2000, 70, 360);
  //emitter->setSpread( 0, M_2_PI);
  emitter->setEmissionRate( 200.0);
  //emitter->setEmissionVelocity( 200.0);
  //emitter->setSystem( explosionParticles);
  //emitter->setAbsCoor( this->getAbsCoor());

  node  = new EmitterNode( .1f);
  node->setupParticle( emitter, explosionParticles);
  node->setAbsDir( this->getAbsDir());
  node->setVelocity( this->getVelocity() * .9f);
  node->setAbsCoor( this->getAbsCoor());
  if( !node->start())
    PRINTF(0)("Explosion node not correctly started!");
/*
  PNode* node          = new PNode();
  node->setAbsCoor(this->getAbsCoor());
  Explosion* explosion = new Explosion();
  explosion->explode( node, Vector(5,5,5));
*/
/*
  if( this->hasPlayer())
  {
	this->setAbsCoor(Vector(-10000,10000,10000));
	this->hide();
  }
  else
  {*/
    //this->setAbsCoor( this->getAbsCoor() + Vector(100,0,0) + Vector(1,0,0) * VECTOR_RAND(150).dot(Vector(1,0,0)));
  //}

  this->toList(OM_NULL);
  this->setAI( false);
  this->setAbsCoor(-10000,-10000,-10000);


}

void NPC::setWeaponConfig(int i)
{
  this->weaponMan.changeWeaponConfig(i);
}

void NPC::addWeapons(const TiXmlElement* root)
{
  if( root == NULL)
    return;

//   LOAD_PARAM_START_CYCLE(root, element);
//   {
// //     PRINTF(0)("got weapon: %s\n", element->Value());
//     BaseObject* obj = Factory::fabricate(element);
//     if( obj != NULL && obj->isA( Weapon::staticClassID()))
//     {
//       Weapon* w = dynamic_cast<Weapon*>(obj);
// //       PRINTF(0)("created a weapon\n");
//       int preferedSlot = w->getPreferedSlot();
//       int preferedSide = w->getPreferedSide();
//
//       this->addWeapon( w, preferedSide, preferedSlot);
//     }
//   }
//   LOAD_PARAM_END_CYCLE(element);
}


/**
 * @brief adds a Weapon to the NPC.
 * @param weapon the Weapon to add.
 * @param configID the Configuration ID to add this weapon to.
 * @param slotID the slotID to add the Weapon to.
 */
bool NPC::addWeapon(Weapon* weapon, int configID, int slotID)
{
  weapon->setOwner(this->getOwner());


  if(this->weaponMan.addWeapon(weapon, configID, slotID))
  {
    return true;
  }
  else
  {
    if (weapon != NULL)
      PRINTF(1)("Unable to add Weapon (%s::%s) to %s::%s\n",
                weapon->getClassCName(), weapon->getCName(), this->getClassCName(), this->getCName());
    else
      PRINTF(1)("No weapon defined\n");
    return false;

  }
}

/**
 * @brief removes a Weapon.
 * @param weapon the Weapon to remove.
 */
void NPC::removeWeapon(Weapon* weapon)
{
  this->weaponMan.removeWeapon(weapon);

}

/**
 * @brief jumps to the next WeaponConfiguration
 */
void NPC::nextWeaponConfig()
{
  this->weaponMan.nextWeaponConfig();
}

/**
 * @brief moves to the last WeaponConfiguration
 */
void NPC::previousWeaponConfig()
{
  this->weaponMan.previousWeaponConfig();
}




/**
 * ticking
 * @param dt  time since last tick
 */
void NPC::tick(float dt)
{
  if( !this->bInit)
  {
    // now get slots from the mount points
    std::map<int, MountPoint*>::iterator it = this->mountPointMap.begin();
    for( ;it != this->mountPointMap.end(); it++)
    {
      WeaponSlot* ws = dynamic_cast<WeaponSlot*>((*it).second->getMount());
      if( ws != NULL && ws->isA(WeaponSlot::staticClassID()))
      {
        int slot = ws->getWeaponSlot();
        int side = ws->getWeaponSide();
        this->getWeaponManager().setSlotPosition(slot, (*it).second->getCenter());
        this->getWeaponManager().setSlotDirection(slot, ws->getRelDir());
//         PRINTF(0)("setting slot %i\n", slot);
//         (*it).second->getCenter().debug();
      }
    }
  this->bInit = true;
  }



  this->weaponMan.tick(dt);
  if (this->bFire)
  {
    weaponMan.fire();
  }
  this->bFire = false;

 if(this->entityTrack)
    this->entityTrack->tick(dt);

}

void NPC::draw() const
{
 if( this->entityTrack != NULL && this->isDrawTrack())
  this->entityTrack->drawGraph();

 WorldEntity::draw();
}

// HACK just to make sure they explode as nice as possible :)
void NPC::hit( float damage, WorldEntity* killer)
{
  this->destroy( killer);
  this->setDamage(killer->getDamage());
}
