/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Silvan Nellen
   co-programmer: ...
*/

/*!
 * @file lua_vector.h
 * A class derived of Vector to be used in Lua
 *
 * It does the same as Vector, but it is a BaseObject and therefore can be made scriptable.
*/

#ifndef __LUA_VECTOR_H_
#define __LUA_VECTOR_H_


#include "base_object.h"
#include "vector.h"

//! 3D LuaVector
/**
        A special class to handle 3D Vectors in Lua
*/
class LuaVector : public Vector, public BaseObject {

//! Declare an ObjectList...
  ObjectListDeclaration(LuaVector);

public:
  LuaVector(float x, float y, float z): Vector(z,y,z) {  this->registerObject(this, LuaVector::_objectList); }
  LuaVector(): Vector(0,0,0) {}
 
  float getX(){return this->x;}
  float getY(){return this->y;}
  float getZ(){return this->z;}

};


#endif /* _LUA_VECTOR_H */
