/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      ...
 *
 */

#include "PluginManager.h"

#include <fstream>

#include "SpecialConfig.h"
#include "Plugin.h"
#include "core/ApplicationPaths.h"
#include "core/command/ConsoleCommandIncludes.h"

namespace orxonox
{
    SetConsoleCommand("PluginManager", "load", &PluginManager::loadPlugin);
    SetConsoleCommand("PluginManager", "unload", &PluginManager::unloadPlugin);

    PluginManager* PluginManager::singletonPtr_s  = 0;

    PluginManager::PluginManager()
    {
    }

    PluginManager::~PluginManager()
    {
        for (std::map<std::string, Plugin*>::iterator it = this->plugins_.begin(); it != this->plugins_.end(); ++it)
            delete it->second;
    }

    void PluginManager::findPlugins()
    {
        const std::vector<std::string>& pluginPaths = ApplicationPaths::getInstance().getPluginPaths();
        for (std::vector<std::string>::const_iterator it = pluginPaths.begin(); it != pluginPaths.end(); ++it)
        {
            std::string name;
            std::string libraryName = (*it);
            std::string filename = libraryName +  + specialConfig::pluginExtension;
            std::ifstream infile(filename.c_str());
            if (infile >> name)
            {
                orxout(internal_info) << "Found plugin with name '" << name << "' in module " << libraryName << endl;
                this->plugins_[name] = new Plugin(name, libraryName);
            }
            else
            {
                orxout(internal_warning) << "Could not read plugin file " << filename << endl;
            }
        }
    }

    /*static*/ void PluginManager::loadPlugin(const std::string& name)
    {
        Plugin* plugin = PluginManager::getInstance().plugins_[name];
        if (plugin != NULL)
            plugin->load();
        else
            orxout(internal_warning) << "Cannot find plugin with name " << name << endl;
    }

    /*static*/ void PluginManager::unloadPlugin(const std::string& name)
    {
        Plugin* plugin = PluginManager::getInstance().plugins_[name];
        if (plugin != NULL)
            plugin->unload();
        else
            orxout(internal_warning) << "Cannot find plugin with name " << name << endl;
    }
}
