/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      ...
 *
 */

#include "Plugin.h"

#include "ModuleInstance.h"
#include "util/Output.h"
#include "core/Core.h"

namespace orxonox
{
    Plugin::Plugin(const std::string& name, const std::string& libraryName) : name_(name), libraryName_(libraryName)
    {
        this->referenceCounter_ = 0;
        this->moduleInstance_ = NULL;
    }

    Plugin::~Plugin()
    {
        if (this->moduleInstance_ != NULL)
        {
            this->referenceCounter_ = 1; // force unloading
            this->unload();
        }
    }

    void Plugin::load()
    {
        if (this->referenceCounter_ == 0)
        {
            orxout(internal_info) << "Loading plugin " << this->name_ << "..." << endl;
            this->moduleInstance_ = new ModuleInstance(this->libraryName_);
            Core::getInstance().loadModule(this->moduleInstance_);
        }
        else
        {
            orxout(internal_info) << "Plugin " << this->name_ << " is already referenced" << endl;
        }

        this->referenceCounter_++;
    }

    void Plugin::unload()
    {
        this->referenceCounter_--;
        if (this->referenceCounter_ == 0)
        {
            orxout(internal_info) << "Unloading plugin " << this->name_ << "..." << endl;
            Core::getInstance().unloadModule(this->moduleInstance_);
            delete this->moduleInstance_;
            this->moduleInstance_ = NULL;
        }
        else if (this->referenceCounter_ > 0)
        {
            orxout(internal_info) << "Plugin " << this->name_ << " is still referenced" << endl;
        }
        else
        {
            orxout(internal_warning) << "Plugin " << this->name_ << " was dereferenced more often than it was reference" << endl;
            this->referenceCounter_ = 0;
        }
    }
}
