/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004-2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Nicolas Schlumberger, Marc Schaerrer
   co-programmer: Benjamin Grauer

*/


#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "lbolt.h"

#include "state.h"
#include "model.h"

#include "particles/dot_emitter.h"
#include "particles/sprite_particles.h"
#include "npcs/npc.h"

#include <cassert>
#include "debug.h"

#include "space_ships/space_ship.h"



ObjectListDefinition(LBolt);
CREATE_FAST_FACTORY_STATIC(LBolt);

/**
 *  standard constructor
*/
LBolt::LBolt () : Projectile()
{
  this->registerObject(this, LBolt::_objectList);

  this->loadModel("models/projectiles/lbolt.obj");

  this->setMinEnergy(1);
  this->setHealthMax(0);
  this->lifeSpan = 1.0;

  this->emitter = new DotEmitter(100, 5, M_2_PI);
  this->emitter->setParent(this);
  this->emitter->setSpread(M_PI, M_PI);
  this->emitter->setEmissionRate(300.0);
  this->emitter->setEmissionVelocity(50.0);

  this->angle = 0;
  this->rotationSpeed = 130;

  this->halo = new Billboard();
  this->halo->setSize(.35, .35);
  this->halo->setTexture("hbolt_halo.png");
  this->halo->setVisibility(false);


}


/**
 *  standard deconstructor
*/
LBolt::~LBolt ()
{
  // delete this->emitter;

  /* this is normaly done by World.cc by deleting the ParticleEngine */
  if (LBolt::explosionParticles != NULL && LBolt::objectList().size() <= 1)
  {
    //if (ClassList::exists(LBolt::explosionParticles, CL_PARTICLE_SYSTEM))
    //  delete LBolt::explosionParticles;
    PRINTF(1)("Deleting LBolt Particles\n");
    LBolt::explosionParticles = NULL;
  }

}

SpriteParticles* LBolt::explosionParticles = NULL;

void LBolt::activate()
{
  this->halo->setVisibility(true);
  this->origList = this->getOMListNumber();
  this->toList(OM_ENVIRON);
  if (unlikely(LBolt::explosionParticles == NULL))
  {
    LBolt::explosionParticles = new SpriteParticles(1000);
    LBolt::explosionParticles->setName("BoltExplosionParticles");
    LBolt::explosionParticles->setLifeSpan(.5, .3);
    LBolt::explosionParticles->setRadius(0.0, 10.0);
    LBolt::explosionParticles->setRadius(.5, 6.0);
    LBolt::explosionParticles->setRadius(1.0, 3.0);
    LBolt::explosionParticles->setColor(0.0, 1,1,0,.9);
    LBolt::explosionParticles->setColor(0.5, .8,.8,0,.5);
    LBolt::explosionParticles->setColor(1.0, .8,.8,.7,.0);
  }

  this->setDamage(5);
  this->setHealth(0);
}


void LBolt::deactivate()
{
  assert (LBolt::explosionParticles != NULL);
  LBolt::explosionParticles->removeEmitter(this->emitter);
  this->halo->setVisibility(false);
  this->lifeCycle = 0.0;

  this->toList(OM_DEAD);
  this->removeNode();
  LBolt::fastFactory->kill(this);
}


void LBolt::hit (float damage, WorldEntity* entity )
{
  PRINTF(0)("Collision with LBolt\n");
  if (this->hitEntity != entity && entity->isA(NPC::staticClassID()))
    this->destroy( entity );
  this->hitEntity = entity;
  this->deactivate();
}

/**
 *  signal tick, time dependent things will be handled here
 * @param dt time since last tick
*/
void LBolt::tick (float dt)
{
  //Vector v = *this->flightDirection * ( this->speed * time * 1000 + 0.1);
  Vector v = this->velocity * dt;
  this->shiftCoor(v);

  if (this->tickLifeCycle(dt))
    this->deactivate();

  angle += rotationSpeed * dt;

  for( ObjectList<Playable>::const_iterator eIterator = Playable::objectList().begin(); eIterator !=Playable::objectList().end(); eIterator++)
  {
    if( ((*eIterator)->getOMListNumber() != (this->origList -1))   && ((*eIterator)->getAbsCoor() - this->getAbsCoor()).len() <= 8)
    {
      (*eIterator)->hit (this->getDamage(),this);
      this->deactivate();
  PRINTF(0)("LBolt destroyed\n");
    }
  }
}

/**
 *  the function gets called, when the projectile is destroyed
*/
void LBolt::destroy (WorldEntity* killer)
{
  Projectile::destroy( killer );
  PRINTF(5)("DESTROY LBolt\n");
  this->lifeCycle = .95; //!< @todo calculate this usefully.

  this->emitter->setSystem(LBolt::explosionParticles);
}


void LBolt::draw () const
{
  glPushAttrib(GL_ENABLE_BIT);
  //glDisable(GL_LIGHTING);

  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  float matrix[4][4];
  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);

  glRotatef(angle, 1.0, 0.0, 0.0);
  this->getAbsDir().matrix (matrix);
  glMultMatrixf((float*)matrix);
  this->getModel()->draw();

  this->halo->draw();

  glPopMatrix();

  glPopAttrib();
}

