/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004-2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Marc Schaerrer
   co-programmer: Benjamin Grauer

*/


#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "acid_splash.h"

#include "state.h"

//#include "space_ships/space_ship.h"

#include <cassert>
#include "debug.h"

//#include "static_model.h"

#include "effects/wobblegrid.h"



ObjectListDefinition(AcidSplash);
CREATE_FAST_FACTORY_STATIC(AcidSplash);

/**
 *  standard constructor
*/
AcidSplash::AcidSplash () : Projectile()
{
  this->registerObject(this, AcidSplash::_objectList);

  srand(time(0));   //initialize Random Nomber Generator

  //this->loadModel("models/projectiles/laser.obj");

  this->setMinEnergy(1);
  this->setHealthMax(0);
  this->lifeSpan = 3.0;
  this->angle     = 0;

  this->grid = new Wobblegrid( 5);
  this->grid->setParent( this);
  this->grid->setVisibility(false);


  int rnd = int(rand() % 3);

  switch (rnd){
    case 0:
      this->grid->setTexture( "textures/acid2.png");
      break;
    case 1:
      this->grid->setTexture( "textures/acid3.png");
      break;
    case 2:
      this->grid->setTexture( "textures/blub.png");
      break;
    default:
      this->grid->setTexture( "textures/acid2.png");
  }
//   if (rand()/2 == 0) //!<Randomized Textrures
//     this->grid->setTexture( "textures/acid3.png");
//   else
//     this->grid->setTexture( "textures/blub.png");

  this->grid->toList(OM_ENVIRON); 
}


/**
 *  standard deconstructor
 *
 */
AcidSplash::~AcidSplash ()
{
  // delete this->emitter;
  //delete this->grid;
  this->grid->toList(OM_DEAD);
  
}


void AcidSplash::activate()
{
  this->origList = this->getOMListNumber();
  this->toList(OM_ENVIRON);
 // this->unhide();
  this->grid->setVisibility(true);

  this->setPhysDamage(10);
  this->setElecDamage(0);
  this->setHealth(0);
}


void AcidSplash::deactivate()
{
  this->lifeCycle = 0.0;

 // this->hide();
  this->grid->setVisibility(false);
  this->lifeCycle = 0.0;
  this->toList(OM_NULL);
  //this->toList(OM_DEAD);
  this->removeNode();
  
  AcidSplash::fastFactory->kill(this);
}

/*
void AcidSplash::collidesWith(WorldEntity* entity, const Vector& location)
{

  if (this->hitEntity != entity)
    this->destroy( entity );
  this->hitEntity = entity;
  //dynamic_cast<SpaceShip*>(entity)->damage(this->getPhysDamage(),this->getElecDamage());
  //this->destroy(this);
  this->deactivate();
  
//   return;

  //dynamic_cast<SpaceShip*>(entity)->damage( this->getPhysDamage(), this->getElecDamage());
  //entity->destroy(this);
  //this->deactivate();
}
*/
/**
 *  signal tick, time dependent things will be handled here
 * @param dt time since last tick
*/
void AcidSplash::tick (float dt)
{
  //Vector v = *this->flightDirection * ( this->speed * time * 1000 + 0.1);
  Vector v = this->velocity * dt;
  this->shiftCoor(v);

  if (this->tickLifeCycle(dt))
    this->deactivate();

  this->angle += this->rotationSpeed * dt;

  this->grid->tick(dt);

  for( ObjectList<Playable>::const_iterator eIterator = Playable::objectList().begin(); eIterator !=Playable::objectList().end(); eIterator++)
  {
    if( ((*eIterator)->getOMListNumber() != (this->origList -1))  && ((*eIterator)->getAbsCoor() - this->getAbsCoor()).len() <= 8)
    {
      (*eIterator)->hit (this->getDamage(),this);
      this->deactivate();
    }
  }

}

/**
 *  the function gets called, when the projectile is destroyed
*/
void AcidSplash::destroy (WorldEntity* killer)
{
  this->deactivate();
  Projectile::destroy( killer );
  PRINTF(5)("DESTROY AcidSplash\n");
  this->lifeCycle = .95; //!< @todo calculate this usefully.
}


void AcidSplash::draw () const
{
  this->grid->draw();
}
