

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 1004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer    std::string             questName;
    std::string             questDescription;
    std::string             questPicture;
    std::string             questDifficulty;
    std::string             rewardDescription;
    std::string             rewardPicture;: Andreas Hejj

*/


#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY

#include "debug.h"
#include "quest_gui.h"

#include "event_handler.h"

#include "state.h"

#include "util/loading/load_param.h"
#include "util/loading/factory.h"

#include "graphics_engine.h"
#include "camera.h"
#include "sound_engine.h"

#include "sound_source.h"

#include "glgui_widget.h"
#include "glgui.h"
#include "menu/glgui_imagebutton.h"
#include "glgui_multiline_text.h"
#include <glgui_image.h>

#include "event_handler.h"

#include "quest.h"

#include "shell_command.h"

ObjectListDefinition(QuestGUI);

CREATE_FACTORY(QuestGUI);



#include "script_class.h"
CREATE_SCRIPTABLE_CLASS(QuestGUI,
                        addMethod("startGUI", Executor0<QuestGUI, lua_State*>(&QuestGUI::startGUI))
                      ->addMethod("stopGUI",  Executor0<QuestGUI, lua_State*>(&QuestGUI::stopGUI))
                      ->addMethod("isActive", Executor0ret<QuestGUI, lua_State*,bool>(&QuestGUI::isActive))
                       );



QuestGUI::QuestGUI(const TiXmlElement* root)
{
  if (root != NULL)
  {
  this->registerObject(this, QuestGUI::_objectList);

  this->toList(OM_GROUP_00);

  this->questBox = NULL;

  this->bKillGui = false;

  this->bActive = false;

  this->myQuest = new Quest(root);

  if(root)
    this->loadParams( root);
  }
}


/**
 * deconstructor
 */
QuestGUI::~QuestGUI ()
{
  if( this->myQuest)
    delete this->myQuest;
}

/**
 * loads the xml tagsthis->questDescription
 * @param root: root xml tag for this element
 */
void QuestGUI::loadParams(const TiXmlElement* root)
{
  WorldEntity::loadParams(root);
}



/**
 * initializes the gui
 */
void QuestGUI::startGUI()
{
  this->bKillGui = false;


  if (questBox == NULL)
  {
    this->questBox= new OrxGui::GLGuiBox(OrxGui::Vertical);
    questBox->setBorderTop(10);
    questBox->setBorderRight(10);
    questBox->setBorderLeft(10);
    questBox->setBorderBottom(10);
    this->questBox->setBackgroundTexture("textures/gui/gui_quest_border.png");

    OrxGui::GLGuiBox* headerBox = new OrxGui::GLGuiBox(OrxGui::Horizontal);
    {
      headerBox->setBackgroundTexture("textures/gui/gui_quest_border_low.png");
      OrxGui::GLGuiImage* questImage = new OrxGui::GLGuiImage();
      questImage->setWidgetSize(100, 100);
      questImage->loadImageFromFile(this->myQuest->getQuestPicture());
      questImage->show();
      headerBox->pack(questImage);

      OrxGui::GLGuiBox* outlineBox = new OrxGui::GLGuiBox(OrxGui::Vertical);
      {
        OrxGui::GLGuiMultiLineText* questDetails = new OrxGui::GLGuiMultiLineText();
        questDetails->setText(this->myQuest->getQuestDifficulty());
        questDetails->append(this->myQuest->getQuestPersons());
        outlineBox->setBorderTop(0);
        outlineBox->setBorderRight(0);
        outlineBox->setBorderLeft(0);
        outlineBox->setBorderBottom(10);
        outlineBox->pack(questDetails);
      }
      headerBox->setBorderTop(0);
      headerBox->setBorderRight(0);
      headerBox->setBorderLeft(0);
      headerBox->setBorderBottom(10);
      headerBox->pack(outlineBox);
    }

    OrxGui::GLGuiBox* labelBox = new OrxGui::GLGuiBox(OrxGui::Horizontal);
    {
      labelBox->setBackgroundTexture("textures/gui/gui_quest_border_low.png");
      OrxGui::GLGuiMultiLineText* questTxt = new OrxGui::GLGuiMultiLineText();
      questTxt->setText(this->myQuest->getQuestDescription());
      labelBox->pack(questTxt);

      OrxGui::GLGuiImage* placeImage = new OrxGui::GLGuiImage();
      placeImage->setWidgetSize(85, 10);
      placeImage->loadImageFromFile("textures/gui/gui_quest_black.png");
      placeImage->show();
      labelBox->pack(placeImage);


      labelBox->setBorderTop(0);
      labelBox->setBorderRight(0);
      labelBox->setBorderLeft(55);
      labelBox->setBorderBottom(10);
    }


    OrxGui::GLGuiBox* rewardBox = new OrxGui::GLGuiBox(OrxGui::Horizontal);
    {
      rewardBox->setBackgroundTexture("textures/gui/gui_quest_border_low.png");
      OrxGui::GLGuiImage* rewardImage = new OrxGui::GLGuiImage();
      rewardImage->setWidgetSize(100, 100);
      rewardImage->loadImageFromFile(this->myQuest->getRewardPicture());
      rewardImage->show();
      rewardBox->pack(rewardImage);

      OrxGui::GLGuiMultiLineText* rewardTxt = new OrxGui::GLGuiMultiLineText();
      rewardTxt->setText(this->myQuest->getRewardDescription());
      rewardBox->setBorderTop(0);
      rewardBox->setBorderRight(0);
      rewardBox->setBorderLeft(0);
      rewardBox->setBorderBottom(10);
      rewardBox->pack(rewardTxt);
    }

    OrxGui::GLGuiBox* answerBox = new OrxGui::GLGuiBox(OrxGui::Horizontal);
    {
      OrxGui::GLGuiImage* placeImage = new OrxGui::GLGuiImage();
      placeImage->setWidgetSize(20, 10);
      placeImage->loadImageFromFile("textures/gui/gui_quest_black.png");
      placeImage->show();
      answerBox->pack(placeImage);

      OrxGui::GLGuiBox* acceptBox = new OrxGui::GLGuiBox(OrxGui::Horizontal);
      {
        //acceptBox->setBackgroundTexture("maps/accept.png");
        acceptBox->setBackgroundTexture("textures/gui/gui_quest_accept.gif", OrxGui::Normal);
        //acceptBox->setBackgroundTexture("maps/gui_quest_acceptrout.png", OrxGui::Selected);
        OrxGui::GLGuiButton* acceptButton = new OrxGui::GLGuiPushButton("        ");
        acceptButton->released.connect(this, &QuestGUI::accept);
        acceptBox->setBorderTop(7);
        acceptBox->setBorderRight(7);
        acceptBox->setBorderLeft(7);
        acceptBox->setBorderBottom(7);
        acceptBox->pack(acceptButton);
      }
      answerBox->pack(acceptBox);

      OrxGui::GLGuiImage* placeImage2 = new OrxGui::GLGuiImage();
      placeImage2->setWidgetSize(300, 10);
      placeImage2->loadImageFromFile("textures/gui/gui_quest_black.png");
      placeImage2->show();
      answerBox->pack(placeImage2);

      OrxGui::GLGuiBox* refuseBox = new OrxGui::GLGuiBox(OrxGui::Horizontal);
      {
        refuseBox->setBackgroundTexture("textures/gui/gui_quest_refuserout.gif");
        OrxGui::GLGuiButton* refuseButton = new OrxGui::GLGuiPushButton("        ");
        refuseButton->released.connect(this, &QuestGUI::refuse);
        refuseBox->setBorderTop(7);
        refuseBox->setBorderRight(7);
        refuseBox->setBorderLeft(7);
        refuseBox->setBorderBottom(7);
        refuseBox->pack(refuseButton);
      }
      answerBox->setBorderTop(15);
      answerBox->setBorderRight(0);
      answerBox->setBorderLeft(0);
      answerBox->setBorderBottom(20);
      answerBox->pack(refuseBox);
    }
    this->questBox->pack(headerBox);
    this->questBox->pack(labelBox);
    this->questBox->pack(rewardBox);
    this->questBox->pack(answerBox);
    this->questBox->showAll();

    this->questBox->setAbsCoor2D(300, 100);

    OrxGui::GLGuiHandler::getInstance()->activate();
    OrxGui::GLGuiHandler::getInstance()->activateCursor();
    EventHandler::getInstance()->pushState( ES_MENU);
  }
}

void QuestGUI::stopGUI()
{
    this->bKillGui = true;
}


void QuestGUI::tick(float dt)
{
  if( this->bKillGui)
    this->killgui();
}


void QuestGUI::accept()
{
  this->myQuest->setQuestActive();
  this->bKillGui = true;
  bActive=true;
}

void QuestGUI::refuse()
{
  this->bKillGui = true;
  bActive=false;
}

void QuestGUI::killgui()
{
  OrxGui::GLGuiHandler::getInstance()->deactivate();
  OrxGui::GLGuiHandler::getInstance()->deactivateCursor();
  EventHandler::getInstance()->popState();
  delete this->questBox;
  this->questBox = NULL;
  this->bKillGui = false;
  //this->bActive = false;
}
