

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "movement_module.h"
#include "ai_module.h"
#include "ai_team.h"
#include "ai_swarm.h"
#include "ai_engine.h"

#include "player.h"
#include "playable.h"

#include "weapons/test_gun.h"
#include "weapons/turret.h"
#include "weapons/cannon.h"

#include "loading/factory.h"
#include "debug.h"
#include "loading/load_param.h"
#include "util/loading/load_param_xml.h"
#include "track/track.h"


#include "weapons/test_gun.h"
#include "weapons/light_blaster.h"
#include "weapons/medium_blaster.h"
#include "weapons/heavy_blaster.h"
#include "weapons/swarm_launcher.h"
#include "weapons/spike_launcher.h"
#include "weapons/spike_thrower.h"
#include "weapons/acid_launcher.h"
#include "weapons/boomerang_gun.h"
#include "weapons/turret.h"
#include "weapons/cannon.h"

#include "npc.h"

ObjectListDefinition(NPC);
CREATE_FACTORY(NPC);


#include "script_class.h"
CREATE_SCRIPTABLE_CLASS(NPC,
                        addMethod("getAbsCoorX", Executor0ret<PNode, lua_State*, float>(&PNode::getAbsCoorX))
                        ->addMethod("getAbsCoorY", Executor0ret<PNode, lua_State*, float>(&PNode::getAbsCoorY))
                        ->addMethod("getAbsCoorZ", Executor0ret<PNode, lua_State*, float>(&PNode::getAbsCoorZ))
                        ->addMethod("setAbsCoor", Executor3<PNode, lua_State*,float,float,float>(&PNode::setAbsCoor))
                        ->addMethod("setAbsDir", Executor4<PNode, lua_State*,float,float,float,float>(&PNode::setAbsDir))
                        ->addMethod("fire", Executor0<NPC, lua_State*>(&NPC::fire))
                        ->addMethod("pause", Executor1<WorldEntity, lua_State*, bool>(&WorldEntity::pauseTrack))
                        ->addMethod("hide", Executor0<WorldEntity, lua_State*>(&WorldEntity::hide))
                        ->addMethod("unhide", Executor0<WorldEntity, lua_State*>(&WorldEntity::unhide))
                       );

NPC::NPC(const TiXmlElement* root)
  : weaponMan(this)
{
  this->registerObject(this, NPC::_objectList);

  this->toList(OM_GROUP_01);
  this->bAIEnabled = false;



   // create the weapons and their manager
  Weapon* wpRight1 = new LightBlaster ();
  wpRight1->setName( "LightBlaster");
  Weapon* wpLeft1 = new LightBlaster ();
  wpLeft1->setName( "LightBlaster");

  Weapon* wpRight2 = new MediumBlaster ();
  wpRight2->setName( "MediumBlaster");
  Weapon* wpLeft2 = new MediumBlaster ();
  wpLeft2->setName( "MediumBlaster");

  Weapon* wpRight3 = new HeavyBlaster (1);
  wpRight3->setName( "HeavyBlaster");
  Weapon* wpLeft3 = new HeavyBlaster (0);
  wpLeft3->setName( "HeavyBlaster");

  Weapon* cannon = new SwarmLauncher();
  cannon->setName( "SwarmLauncher");

  Weapon* spike = new SpikeThrower();
  spike->setName( "SpikeThrower" );


  Weapon* acid0 = new AcidLauncher();
  acid0->setName( "AcidSplasher" );

  Weapon* acid1 = new AcidLauncher();
  acid1->setName( "AcidSplasher" );


  this->weaponMan.addWeapon( wpLeft1, 0, 0);
  this->weaponMan.addWeapon( wpRight1, 0, 1);

  this->weaponMan.addWeapon( wpLeft2, 1, 2);
  this->weaponMan.addWeapon( wpRight2, 1, 3);

  this->weaponMan.addWeapon( wpLeft3, 2, 4);
  this->weaponMan.addWeapon( wpRight3, 2, 5);
/*
  this->weaponMan.addWeapon( wpLeft1, 3, 0);
  this->weaponMan.addWeapon( wpRight1, 3, 1);

  this->weaponMan.addWeapon( wpLeft2, 3, 2);
  this->weaponMan.addWeapon( wpRight2, 3, 3);

  this->weaponMan.addWeapon( wpLeft3, 3, 4);
  this->weaponMan.addWeapon( wpRight3, 3, 5);
*/

  this->weaponMan.addWeapon( acid0, 3, 0);
  this->weaponMan.addWeapon( acid1, 3, 1);


  if( root != NULL)
    this->loadParams(root);

  if( this->bAIEnabled && ! this->entityTrack)
  {
    std::cout << "Team Number: " << teamNumber << "\n";
    std::cout << "Swarm Number:" << swarmNumber << "\n";

    AIEngine::getInstance()->addAI(teamNumber,swarmNumber,(WorldEntity*)this,maxSpeed,attackDistance);
  }

  this->bFire = false;
  if( this->entityTrack)
  {
      this->setParent(this->entityTrack->getTrackNode());
      this->setRelCoor(0,0,0);
  }




//   this->secWeaponMan.addWeapon( acid0, 2, 2);
//   this->secWeaponMan.addWeapon( acid1, 2, 3);


//   this->weaponMan.changeWeaponConfig(3);

//   this->getWeaponManager().changeWeaponConfig(1);

  this->setHealthMax(100);
  this->setHealth(80);

  this->getWeaponManager().setSlotCount(7);

  this->getWeaponManager().setSlotPosition(0, Vector(-2.6, .1, -3.0));
  this->getWeaponManager().setSlotCapability(0, WTYPE_ALLDIRS | WTYPE_DIRECTIONAL);

  this->getWeaponManager().setSlotPosition(1, Vector(-2.6, .1, 3.0));
  this->getWeaponManager().setSlotCapability(1, WTYPE_ALLDIRS | WTYPE_DIRECTIONAL);

  this->getWeaponManager().setSlotPosition(2, Vector(-1.5, .5, -.5));
  this->getWeaponManager().setSlotDirection(2, Quaternion(-M_PI_4*.5, Vector(1,0,0)));

  this->getWeaponManager().setSlotPosition(3, Vector(-1.5, .5, .5));
  this->getWeaponManager().setSlotDirection(3, Quaternion(M_PI_4*.5, Vector(1,0,0)));

  this->getWeaponManager().setSlotPosition(4, Vector(-1.5, -.5, .5));
  this->getWeaponManager().setSlotDirection(4, Quaternion(-M_PI_4*.5+M_PI, Vector(1,0,0)));

  this->getWeaponManager().setSlotPosition(5, Vector(-1.5, -.5, -.5));
  this->getWeaponManager().setSlotDirection(5, Quaternion(+M_PI_4*.5-M_PI, Vector(1,0,0)));

  this->getWeaponManager().setSlotPosition(6, Vector(-1, 0.0, 0));
  this->getWeaponManager().setSlotCapability(6, WTYPE_ALLDIRS | WTYPE_DIRECTIONAL);

  this->getWeaponManager().getFixedTarget()->setParent(this);
  this->getWeaponManager().getFixedTarget()->setRelCoor(100000,0,0);




}


NPC::~NPC ()
{
 if(! this->entityTrack)
  AIEngine::getInstance()->removeAI(teamNumber,swarmNumber,(WorldEntity*)this);
}



/**
 * loads the xml tags
 * @param root: root xml tag for this element
 */
void NPC::loadParams(const TiXmlElement* root)
{
   WorldEntity::loadParams(root);

  LoadParam(root, "enableAI", this, NPC, enableAI)
      .describe("enables the AI algorithms");

  LoadParam(root, "team", this, NPC, setTeamNumber)
  .describe("this sets the team number")
  .defaultValues(0);

  LoadParam(root, "swarm", this, NPC, setSwarmNumber)
  .describe("this sets the swarm number")
  .defaultValues(0);

  LoadParam(root, "maxSpeed", this, NPC, setMaxSpeed)
  .describe("this sets the NPC max Speed")
  .defaultValues(0);

  LoadParam(root, "attackDistance", this, NPC, setAttackDistance)
  .describe("this sets the NPC distance to target")
  .defaultValues(0);

  LoadParam(root, "weapon-config", this, NPC, setWeaponConfig);

//   LoadParamXML(root, "Weapons", this, NPC, addWeapons)
//   .describe("creates and adds weapons");
}


void NPC::setWeaponConfig(int i)
{
  this->weaponMan.changeWeaponConfig(i);
}

void NPC::addWeapons(const TiXmlElement* root)
{
  if( root == NULL)
    return;

  LOAD_PARAM_START_CYCLE(root, element);
  {
    PRINTF(0)("got weapon: %s\n", element->Value());
    BaseObject* obj = Factory::fabricate(element);
    if( obj != NULL && obj->isA( Weapon::staticClassID()))
    {
      Weapon* w = dynamic_cast<Weapon*>(obj);
      PRINTF(0)("created a weapon\n");
      int preferedSlot = w->getPreferedSlot();
      int preferedSide = w->getPreferedSide();

      this->addWeapon( w, preferedSide, preferedSlot);
    }
  }
  LOAD_PARAM_END_CYCLE(element);
}


/**
 * @brief adds a Weapon to the NPC.
 * @param weapon the Weapon to add.
 * @param configID the Configuration ID to add this weapon to.
 * @param slotID the slotID to add the Weapon to.
 */
bool NPC::addWeapon(Weapon* weapon, int configID, int slotID)
{
  weapon->setOwner(this->getOwner());


  if(this->weaponMan.addWeapon(weapon, configID, slotID))
  {
    return true;
  }
  else
  {
    if (weapon != NULL)
      PRINTF(1)("Unable to add Weapon (%s::%s) to %s::%s\n",
                weapon->getClassCName(), weapon->getCName(), this->getClassCName(), this->getCName());
    else
      PRINTF(1)("No weapon defined\n");
    return false;

  }
}

/**
 * @brief removes a Weapon.
 * @param weapon the Weapon to remove.
 */
void NPC::removeWeapon(Weapon* weapon)
{
  this->weaponMan.removeWeapon(weapon);

}

/**
 * @brief jumps to the next WeaponConfiguration
 */
void NPC::nextWeaponConfig()
{
  this->weaponMan.nextWeaponConfig();
}

/**
 * @brief moves to the last WeaponConfiguration
 */
void NPC::previousWeaponConfig()
{
  this->weaponMan.previousWeaponConfig();
}




/**
 * ticking
 * @param dt  time since last tick
 */
void NPC::tick(float dt)
{
  this->weaponMan.tick(dt);
  if (this->bFire)
  {
    std::cout << "fire..\n";
    weaponMan.fire();
  }
  this->bFire = false;

 if(this->entityTrack)
    this->entityTrack->tick(dt);

}

void NPC::draw() const
{
 if( this->entityTrack != NULL && this->isDrawTrack())
  this->entityTrack->drawGraph();

 WorldEntity::draw();
}
