
#ifndef _QUESTGUI_H
#define _QUESTGUI_H

#include "world_entity.h"
#include "glgui.h"
#include <glgui_image.h>
#include <vector>

class Quest;

class QuestGUI : public WorldEntity
{

  ObjectListDeclaration(QuestGUI);

  public:
   QuestGUI (const TiXmlElement* root = NULL);
   virtual ~QuestGUI ();

   void loadParams(const TiXmlElement* root);
   bool isActive(){ return this->bActive; }

   void startGUI();
   void stopGUI();

   virtual void tick(float dt);

  private:
    Quest*                  myQuest;
    bool                    bKillGui;
    bool                    bActive;

    OrxGui::GLGuiBox*       headerBox;
    OrxGui::GLGuiBox*       outlineBox;
    OrxGui::GLGuiBox*       labelBox;
    OrxGui::GLGuiImage*     placeImage;
    OrxGui::GLGuiBox*       questBox;
    OrxGui::GLGuiImage*     questImage;
    OrxGui::GLGuiBox*       rewardBox;
    OrxGui::GLGuiImage*     rewardImage;
    OrxGui::GLGuiBox*       answerBox;
    OrxGui::GLGuiImage*     placeImage2;
    OrxGui::GLGuiBox*       acceptBox;
    OrxGui::GLGuiBox*       refuseBox;


    OrxSound::SoundSource*  selectorSource;

    void accept();
    void refuse();
    void killgui();
};

#endif /* _QUESTGUI_H */
