
#include "resource_md2.h"
#include "substring.h"
#include "multi_type.h"
#include "debug.h"


ResourceMD2::ResourceMD2(const std::string& modelName, const std::string& skinName, float scale, const Resources::KeepLevel& keepLevel)
    : Resource(&ResourceMD2::type)
{
  Resources::StorePointer* ptr = this->acquireResource(loadString(modelName, skinName, scale));

  if (ptr)
  {
    PRINTF(4)("FOUND MD2: %s\n", modelName.c_str());
    this->acquireData(static_cast<ResourceMD2::MD2ResourcePointer*>(ptr)->ptr());
  }
  else
  {
    PRINTF(4)("NOT FOUND MD2: %s\n", modelName.c_str());
    std::string modelFileName = this->Resource::locateFile(modelName);
    std::string skinFileName = this->Resource::locateFile(skinName);
    PRINTF(4)("NEW %s::%s\n", modelName.c_str(), modelFileName.c_str());
    this->MD2Model::load(modelFileName, skinName, scale);
    this->Resource::addResource(new ResourceMD2::MD2ResourcePointer(loadString(modelName, skinFileName, scale), keepLevel, this->MD2Model::dataPointer()));
  }

}

ResourceMD2 ResourceMD2::createFromString(const std::string& loadString, const Resources::KeepLevel& keepLevel)
{
  SubString loadValues(loadString, ',');
  std::string modelName;
  std::string skinName;
  float scale = 1.0f;
  if (loadValues.size() > 0)
    modelName = loadValues[0];
  if (loadValues.size() > 1)
    skinName = loadValues[1];
  if (loadValues.size() > 2)
    scale = MultiType(loadValues[2]).getFloat();

  return ResourceMD2(modelName, skinName, scale, keepLevel);
}

std::string ResourceMD2::loadString(const std::string& modelName, const std::string& skinName, float scale)
{
  return modelName + ',' + skinName + ',' + MultiType(scale).getString();
}


Resources::tType<ResourceMD2> ResourceMD2::type("MD2");





ResourceMD2::MD2ResourcePointer::MD2ResourcePointer(const std::string& loadString, const Resources::KeepLevel& keepLevel, const MD2Data::Pointer& data)
    : Resources::StorePointer(loadString, keepLevel) , pointer(data)
{}


