#ifndef _SCROLLING_SCREEN_H
#define _SCROLLING_SCREEN_H

#include "world_entity.h"


class TiXmlElement;
class Material;

class ScrollingScreen : public WorldEntity
{
  ObjectListDeclaration(ScrollingScreen);



public:
  ScrollingScreen();
  ScrollingScreen(const TiXmlElement* root);
  virtual ~ScrollingScreen();

  typedef enum ScScMode
  {
     SCSC_FULL  = 0,
     SCSC_VIEW
  };

  void init();
  virtual void loadParams(const TiXmlElement* root);

  void fadeIn(float speed);
  void fadeOut(float speed);

  void setTexture(const std::string& texture);

  void setSpeed(float speed) { this->scrollingSpeed = speed; }
  void setViewHeight(float height) { this->viewHeight = height; }
  void setSizeY(float ySize) { this->ySize = ySize; }
  void setSizeX(float xSize) { this->xSize = xSize; }

  virtual void tick (float time);

  virtual void draw() const;
  void drawFull() const;
  void drawView() const;


private:
  Material*       material;
  bool            isTransparent;
  float           transparency;
  float           fadeingSpeed;

  float           scrollingSpeed;
  float           viewHeight;
  float           offset;
  float           ratio;

  float           xSize;
  float           ySize;

  int             mode;

};

#endif /* _SCROLLING_SCREEN_H */
