#ifndef _SCROLLING_SCREEN_H
#define _SCROLLING_SCREEN_H

#include "world_entity.h"


class TiXmlElement;
class Material;

class ScrollingScreen : public WorldEntity
{
  ObjectListDeclaration(ScrollingScreen);



public:
  ScrollingScreen();
  ScrollingScreen(const TiXmlElement* root);
  virtual ~ScrollingScreen();

  void init();
  virtual void loadParams(const TiXmlElement* root);

  void fadeIn(float speed);
  void fadeOut(float speed);

  void setSpeed(float speed) { this->scrollingSpeed = speed; }
  void setViewHeight(float height) { this->viewHeight = height; }
  void setSize(float xSize, float ySize) { this->xSize = xSize; this->ySize = ySize; }

  virtual void tick (float time);

  virtual void draw() const;

private:
  Material*       material;
  bool            isTransparent;
  float           transparency;
  float           fadeingSpeed;

  float           scrollingSpeed;
  float           viewHeight;

  float           xSize;
  float           ySize;


};

#endif /* _SCROLLING_SCREEN_H */
